#include <gsl/gsl_sf_hyperg.h>

/* function names generated by removing  "gsl_sf" from the beginning
   of the name.  Thus gsl_sf_dawson  goes to dawson. */


void hyperg_0F1_e(double *c, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_0F1_e(c[i], x[i] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  

void hyperg_1F1_int_e(double *m, double *n, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_1F1_int_e(m[i], n[i] , x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  

void hyperg_1F1_e(double *a, double *b, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_1F1_e(a[i], b[i] , x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  


void hyperg_U_int_e(double *m, double *n, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_U_int_e(m[i], n[i] , x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  


void hyperg_U_e(double *a, double *b, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_U_e(a[i], b[i] , x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  



void hyperg_2F1_e(double *a, double *b, double *c, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_2F1_e(a[i], b[i] , c[i], x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}
  
void hyperg_2F1_conj_e(double *aR, double *aI, double *c, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_2F1_conj_e(aR[i], aI[i] , c[i], x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  



void hyperg_2F1_renorm_e(double *a, double *b, double *c, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_2F1_e(a[i], b[i] , c[i], x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}



void hyperg_2F1_conj_renorm_e(double *aR, double *aI, double *c, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_2F1_conj_renorm_e(aR[i], aI[i] , c[i], x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  


void hyperg_2F0_e(double *a, double *b, double *x, int *nx, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();

  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_hyperg_2F0_e(a[i], b[i], x[i], &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  

