% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsample.R
\name{upsample}
\alias{upsample}
\title{Increase sample rate}
\usage{
upsample(x, n, phase = 0)
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{n}{upsampling factor, specified as a positive integer. The signal is
upsampled by inserting \code{n - 1} zeros between samples.}

\item{phase}{offset, specified as a positive integer from \code{0} to \code{n
- 1}. Default: 0.}
}
\value{
Upsampled signal, returned as a vector or matrix.
}
\description{
Upsample a signal by an integer factor.
}
\examples{
x <- seq_len(4)
u <- upsample(x, 3)
u <- upsample(x, 3, 2)

x <- matrix(seq_len(6), 3, byrow = TRUE)
u <- upsample(x, 3)

}
\seealso{
\code{\link{downsample}}, \code{\link{interp}},
  \code{\link{decimate}}, \code{\link{resample}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
