% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bartlett.R
\name{bartlett}
\alias{bartlett}
\title{Bartlett window}
\usage{
bartlett(n)
}
\arguments{
\item{n}{Window length, specified as a positive integer.}
}
\value{
Bartlett window, returned as a vector. If you specify a one-point
  window \code{(n = 1)}, the value 1 is returned.
}
\description{
Return the filter coefficients of a Bartlett (triangular) window.
}
\details{
The Bartlett window is very similar to a triangular window as returned by the
\code{\link{triang}} function. However, the Bartlett window always has zeros
at the first and last samples, while the triangular window is nonzero at
those points.
}
\examples{

bw <- bartlett(64)
plot (bw, type = "l", xlab = "Samples", ylab =" Amplitude")

}
\seealso{
\code{\link{triang}}
}
\author{
Andreas Weingessel, \email{Andreas.Weingessel@ci.tuwien.ac.at}.
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
