% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_zi.R
\name{filter_zi}
\alias{filter_zi}
\alias{filter_zi.default}
\alias{filter_zi.Arma}
\alias{filter_zi.Ma}
\alias{filter_zi.Sos}
\title{Filter initial conditions}
\usage{
filter_zi(filt, ...)

\method{filter_zi}{default}(filt, a, ...)

\method{filter_zi}{Arma}(filt, ...)

\method{filter_zi}{Ma}(filt, ...)

\method{filter_zi}{Sos}(filt, ...)
}
\arguments{
\item{filt}{For the default case, the moving-average coefficients of an ARMA
filter (normally called \code{b}), specified as a vector.}

\item{...}{additional arguments (ignored).}

\item{a}{the autoregressive (recursive) coefficients of an ARMA filter,
specified as a vector.}
}
\value{
The initial state for the filter, returned as a vector.
}
\description{
Construct initial conditions for a filter
}
\details{
This function computes an initial state for the filter function that
corresponds to the steady state of the step response. In other words, it
finds the initial condition for which the response to an input of all ones is
a constant. Therefore, the results returned by this function can also be
obtained using the function \code{\link{filtic}} by setting \code{x} and
\code{y} to all 1s (see the examples).

A typical use of this function is to set the initial state so that the output
of the filter starts at the same value as the first element of the signal to
be filtered.
}
\examples{
## taken from Python scipy.signal.lfilter_zi documentation

h <- butter(5, 0.25)
zi <- filter_zi(h)
y <- filter(h, rep(1, 10), zi)
## output is all 1, as expected.
y2 <- filter(h, rep(1, 10))
## if the zi argument is not given, the output
## does not return the final conditions

x <- c(0.5, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0)
y <- filter(h, x, zi = zi*x[1])
## Note that the zi argument to filter was computed using
## filter_zi and scaled by x[1]. Then the output y has no
## transient until the input drops from 0.5 to 0.0.

## obtain the same results with filtic
lab <- max(length(h$b), length(h$a)) - 1
ic <- filtic(h, rep(1, lab), rep(1, lab))
all.equal(zi, ic)

}
\references{
Gustafsson, F. (1996). Determining the initial states in
  forward-backward filtering. IEEE Transactions on Signal Processing, 44(4),
  988 - 992.
}
\seealso{
\code{\link{filtic}}
}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com},
 converted to R from Python scipy.signal.lfilter_zi.
}
