% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp.R
\name{interp}
\alias{interp}
\title{Interpolation}
\usage{
interp(x, q, n = 4, Wc = 0.5)
}
\arguments{
\item{x}{input data, specified as a numeric vector.}

\item{q}{interpolation factor, specified as a positive integer.}

\item{n}{Half the number of input samples used for interpolation, specified
as a positive integer. For best results, use \code{n} no larger than 10.
The low-pass interpolation filter has length \code{2 × n × q + 1}. Default:
4.}

\item{Wc}{Normalized cutoff frequency of the input signal, specified as a
positive real scalar not greater than 1 that represents a fraction of the
Nyquist frequency. A value of 1 means that the signal occupies the full
Nyquist interval. Default: 0.5.}
}
\value{
interpolated signal, returned as a vector.
}
\description{
Increase sample rate by integer factor.
}
\examples{
# Generate a signal
t <- seq(0, 2, 0.01)
x <- chirp(t, 2, .5, 10,'quadratic') + sin(2 * pi * t * 0.4)
w <- seq(1, 121, 4)
plot(t[w] * 1000, x[w], type = "h", xlab = "", ylab = "")
points(t[w] * 1000, x[w])
abline (h = 0)
y <- interp(x[seq(1, length(x), 4)], 4, 4, 1)
lines(t[1:121] * 1000, y[1:121], type = "l", col = "red")
points(t[1:121] * 1000, y[1:121], col = "red", pch = '+')
legend("topleft", legend = c("original", "interpolated"),
  lty = 1, pch = c(1, 3), col = c(1, 2))

}
\seealso{
\code{\link{decimate}}, \code{\link{resample}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
