% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toInteger.R
\name{toInteger}
\alias{toInteger}
\title{Translate group sequential design to integer events (survival designs)
or sample size (other designs)}
\usage{
toInteger(x, ratio = 0, roundUpFinal = TRUE)
}
\arguments{
\item{x}{An object of class \code{gsDesign} or \code{gsSurv}.}

\item{ratio}{A non-negative integer, usually corresponding to experimental:control sample size ratio. 
Rounding is done to a multiple of \code{ratio + 1}. If input \code{x} has class \code{gsSurv} (design for time-to-event outcome),
and \code{x$ratio} is a whole number, \code{ratio} is replaced by \code{x$ratio}.
See details.}

\item{roundUpFinal}{Final value in returned \code{n.I} is rounded up
if \code{TRUE}; otherwise, just rounded. For \code{gsSurv} input, final total sample size is also controlled by this. See details.}
}
\value{
Output is an object of the same class as input \code{x}; i.e., \code{gsDesign} with integer vector for \code{n.I}
or \code{gsSurv} with integer vector \code{n.I} and integer total sample size. See details.
}
\description{
Translate group sequential design to integer events (survival designs)
or sample size (other designs)
}
\details{
If \code{ratio = 3}, rounding for final sample size is done to a multiple of 3 + 1 = 4. 
For a \code{gsSurv} object input in \code{x}, event counts output in \code{n.I} are rounded to nearest integer and 
final total sample size is rounded to a multiple of \code{ratio + 1}.
For other input values of \code{x} (\code{gsDesign} class), \code{n.I} is interpreted as sample size; 
final value is rounded to a multiple of \code{ratio + 1}, with \code{roundUpFinal} controlling rounding of last value.
}
\examples{
# The following code derives the group sequential design using the method
# of Lachin and Foulkes

x <- gsSurv(
  k = 3,                 # 3 analyses
  test.type = 4,         # Non-binding futility bound 1 (no futility bound) and 4 are allowable
  alpha = .025,          # 1-sided Type I error
  beta = .1,             # Type II error (1 - power)
  timing = c(0.45, 0.7), # Proportion of final planned events at interims
  sfu = sfHSD,           # Efficacy spending function
  sfupar = -4,           # Parameter for efficacy spending function
  sfl = sfLDOF,          # Futility spending function; not needed for test.type = 1
  sflpar = 0,            # Parameter for futility spending function
  lambdaC = .001,        # Exponential failure rate
  hr = 0.3,              # Assumed proportional hazard ratio (1 - vaccine efficacy = 1 - VE)
  hr0 = 0.7,             # Null hypothesis VE
  eta = 5e-04,           # Exponential dropout rate
  gamma = 10,            # Piecewise exponential enrollment rates
  R = 16,                # Time period durations for enrollment rates in gamma
  T = 24,                # Planned trial duration
  minfup = 8,            # Planned minimum follow-up
  ratio = 3              # Randomization ratio (experimental:control)
)
# Convert bounds to exact binomial bounds
toInteger(x, ratio = 3)
}
