% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_rtf.R
\name{as_rtf}
\alias{as_rtf}
\alias{as_rtf.gsBinomialExactTable}
\title{Save a summary table object as an RTF file}
\usage{
as_rtf(x, ...)

\method{as_rtf}{gsBinomialExactTable}(
  x,
  file,
  ...,
  title = paste("Operating Characteristics by Underlying Response Rate for",
    "Exact Binomial Group Sequential Design"),
  theta_label = "Underlying Response Rate",
  response_outcome = TRUE,
  bound_label = if (response_outcome) c("Futility Bound", "Efficacy Bound") else
    c("Efficacy Bound", "Futility Bound"),
  en_label = "Expected Sample Sizes",
  prob_decimals = 2,
  en_decimals = 1,
  rr_decimals = 0
)
}
\arguments{
\item{x}{Object to be saved as RTF file.}

\item{...}{Other parameters that may be specific to the object.}

\item{file}{File path for the output.}

\item{title}{Table title.}

\item{theta_label}{Label for theta.}

\item{response_outcome}{Logical values indicating if the outcome is
response rate (\code{TRUE}) or failure rate (\code{FALSE}).
The default value is \code{TRUE}.}

\item{bound_label}{Label for bounds.
If the outcome is response rate, then the label is "Futility bound"
and "Efficacy bound".
If the outcome is failure rate, then the label is "Efficacy bound"
and "Futility bound".}

\item{en_label}{Label for expected number.}

\item{prob_decimals}{Number of decimal places for probability of crossing.}

\item{en_decimals}{Number of decimal places for expected number of
observations when bound is crossed or when trial ends without crossing.}

\item{rr_decimals}{Number of decimal places for response rates.}
}
\value{
\code{as_rtf()} returns the input \code{x} invisibly.
}
\description{
Convert and save the summary table object created with \code{\link{as_table}}
to an RTF file using r2rtf; currently only implemented for
\code{\link{gsBinomialExact}}.
}
\details{
Currently only implemented for \code{\link{gsBinomialExact}} objects.
Creates a table to summarize an object.
For \code{\link{gsBinomialExact}}, this summarized operating characteristics
across a range of effect sizes.
}
\examples{
zz <- gsBinomialExact(
  k = 3, theta = seq(0.1, 0.9, 0.1), n.I = c(12, 24, 36),
  a = c(-1, 0, 11), b = c(5, 9, 12)
)
zz \%>\%
  as_table() \%>\%
  as_rtf(
    file = tempfile(fileext = ".rtf"),
    title = "Power/Type I Error and Expected Sample Size for a Group Sequential Design"
  )

safety_design <- binomialSPRT(
  p0 = .04, p1 = .1, alpha = .04, beta = .2, minn = 4, maxn = 75
)
safety_power <- gsBinomialExact(
  k = length(safety_design$n.I),
  theta = seq(.02, .16, .02),
  n.I = safety_design$n.I,
  a = safety_design$lower$bound,
  b = safety_design$upper$bound
)
safety_power \%>\%
  as_table() \%>\%
  as_rtf(
    file = tempfile(fileext = ".rtf"),
    theta_label = "Underlying\nAE Rate",
    prob_decimals = 3,
    bound_label = c("Low Rate", "High Rate")
  )
}
\seealso{
\code{vignette("binomialSPRTExample")}
}
