% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{gr_plot_matrix}
\alias{gr_plot_matrix}
\title{Runoff matrix plot}
\usage{
gr_plot_matrix(df, years = NULL, type = "runoff", print = TRUE)
}
\arguments{
\item{df}{\code{data.frame} of hydrograph separation produced by \code{\link[=gr_separate]{gr_separate()}}.}

\item{years}{Integer vector of years to be plotted. Defaults to \code{NULL}.}

\item{type}{Character string. Supported options are \code{'runoff'}, \code{'component'}, and \code{'season'}. Defaults to \code{'runoff'}.}

\item{print}{Boolean. Print plot? Defaults to \code{TRUE}. Use \code{FALSE} if you want to tweak the plot aesthetics before plotting.}
}
\value{
\code{ggplot2} object representing the runoff values, components or seasons using the matrix-based approach
}
\description{
The function plots runoff values, components and seasons using the matrix-based approach. The X axis corresponds to the day of the year, and the Y axis corresponds to the year. The function is useful when the whole picture of river runoff needs to be assessed.
}
\examples{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# matrix plot for runoff
gr_plot_matrix(sep, type = 'runoff')

# matrix plot for seasons
gr_plot_matrix(sep, type = 'season')

# matrix plot for genetic components
gr_plot_matrix(sep, type = 'component')
}
