% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/importance.R
\name{importance}
\alias{importance}
\title{Arrange and visualize the importance of groups}
\usage{
importance(grp.values, n = 10, plot = TRUE)
}
\arguments{
\item{grp.values}{The result from \code{\link{grp.criValues}}.}

\item{n}{Number of important groups to display. The default is the top 10 groups.}

\item{plot}{A logical value indicating whether to make a barplot of the importance of
groups.}
}
\value{
A matrix containing the first \code{n} important group indices and values of
screening criterion.
}
\description{
Arranges and visualizes the importance of groups for the results of
\code{\link{grp.criValues}}.
}
\details{
This function arranges the values of screening criterion from the most important
to the least important, and then make a barplot to visualize the importance.
}
\examples{
library(MASS)
n <- 30 # sample size
p <- 3  # number of predictors in each group
J <- 50 # number of groups
group <- rep(1:J,each = 3)  # group indices
Sigma <- diag(p*J)  # covariance matrix
X <- mvrnorm(n,seq(0,5,length.out = p*J),Sigma)
beta <- runif(12,-2,5)  # coefficients
y <- X\%*\%matrix(c(beta,rep(0,p*J-12)),ncol = 1) + rnorm(n)

crivalues <- grp.criValues(X,y,group)  # gSIS
importance(crivalues, n = 20)
}
\author{
Debin Qiu, Jeongyoun Ahn
}
\seealso{
\code{\link{grp.criValues}}
}

