% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization.R
\name{proximalGradientSolverGroupSLOPE}
\alias{proximalGradientSolverGroupSLOPE}
\title{Proximal gradient method for Group SLOPE}
\usage{
proximalGradientSolverGroupSLOPE(y, A, group, wt, lambda,
  max.iter = 10000, verbose = FALSE, dual.gap.tol = 1e-06,
  infeas.tol = 1e-06, x.init = NULL, ...)
}
\arguments{
\item{y}{the response vector}

\item{A}{the model matrix}

\item{group}{A vector describing the grouping structure. It should
contain a group id for each predictor variable.}

\item{wt}{A vector of weights (per coefficient)}

\item{lambda}{A decreasing sequence of regularization parameters \eqn{\lambda}}

\item{max.iter}{Maximal number of iterations to carry out}

\item{verbose}{A \code{logical} specifying whether to print output or not}

\item{dual.gap.tol}{The tolerance used in the stopping criteria for the duality gap}

\item{infeas.tol}{The tolerance used in the stopping criteria for the infeasibility}

\item{x.init}{An optional initial value for the iterative algorithm}

\item{...}{Options passed to \code{\link{prox_sorted_L1}}}
}
\value{
A list with the entries:
  \describe{
    \item{x}{Solution (n-by-1 matrix)}
    \item{status}{Convergence status: 1 if optimal, 2 if iteration limit reached}
    \item{L}{Approximation of the Lipschitz constant (step size)}
    \item{iter}{Iterations of the proximal gradient method}
    \item{L.iter}{Total number of iterations spent in Lipschitz search}
  }
}
\description{
Compute the coefficient estimates for the Group SLOPE problem.
}
\details{
\code{proximalGradientSolverGroupSLOPE} computes the coefficient estimates
for the Group SLOPE model. The employed optimization algorithm is FISTA with
backtracking Lipschitz search.
}
\examples{
set.seed(1)
A   <- matrix(runif(100, 0, 1), 10, 10)
grp <- c(0, 0, 1, 1, 2, 2, 2, 2, 2, 3)
wt  <- c(2, 2, 2, 2, 5, 5, 5, 5, 5, 1)
x   <- c(0, 0, 5, 1, 0, 0, 0, 1, 0, 3)
y   <- A \%*\% x
lam <- 0.1 * (10:7)
result <- proximalGradientSolverGroupSLOPE(y=y, A=A, group=grp, wt=wt, lambda=lam, verbose=FALSE)
result$x
#           [,1]
#  [1,] 0.000000
#  [2,] 0.000000
#  [3,] 3.856005
#  [4,] 2.080736
#  [5,] 0.000000
#  [6,] 0.000000
#  [7,] 0.000000
#  [8,] 0.000000
#  [9,] 0.000000
# [10,] 3.512833

}
\references{
D. Brzyski, A. Gossmann, W. Su, and M. Bogdan (2016) \emph{Group SLOPE -- adaptive selection of groups of predictors}, \url{https://arxiv.org/abs/1610.04960}

D. Brzyski, A. Gossmann, W. Su, and M. Bogdan (2019) \emph{Group SLOPE -- adaptive selection of groups of predictors}. Journal of the American Statistical Association 114 (525): 419–33. \url{http://dx.doi.org/10.1080/01621459.2017.1411269}

A. Gossmann, S. Cao, Y.-P. Wang (2015) \emph{Identification of Significant Genetic Variants via SLOPE, and Its Extension to Group SLOPE}. In Proceedings of ACM BCB 2015. \url{http://dx.doi.org/10.1145/2808719.2808743}
}
