% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_gompertz2.R
\name{grow_gompertz2}
\alias{grow_gompertz2}
\alias{grow_gompertz3}
\title{Growth Model According to Gompertz}
\usage{
grow_gompertz2(time, parms)

grow_gompertz3(time, parms)
}
\arguments{
\item{time}{vector of time steps (independent variable).}

\item{parms}{named parameter vector of the Gompertz growth model with:
\itemize{
  \item \code{y0} initial value of abundance,
  \item \code{mumax} maximum growth rate (1/time),
  \item \code{K} maximum abundance (carrying capacity),
  \item \code{lambda} time of lag phase of the 3 parameter Gompertz model .
}}
}
\value{
vector of dependent variable (\code{y})
}
\description{
Gompertz growth model written as analytical solution of the differential
  equation system.
}
\details{
The equation used here is:

\deqn{y = y0*(K/y0)^(exp(-exp((exp(1)*mumax*(lambda - time))/log(K/y0)+1)))}

Functions \code{grow_gompert2} and \code{grow_gompertz3} describe
  sigmoidal growth with an exponentially decreasing intrinsic growth rate with
  or without an additional lag parameter. The formula follows the
  reparametrization of Zwietering et al (1990), with parameters that have
  a biological meaning.
}
\examples{

time <- seq(0, 30, length=200)
y    <- grow_gompertz(time, c(y0=1, mumax=.2, K=10))[,"y"]
plot(time, y, type="l", ylim=c(0, 12))


}
\references{
Tsoularis, A. (2001) Analysis of Logistic Growth Models.
  Res. Lett. Inf. Math. Sci, (2001) 2, 23-46.

Zwietering, M. H., Jongenburger, I., Rombouts, F. M., and Van't Riet, K.
  (1990). Modeling of the bacterial growth curve.
  Appl. Environ. Microbiol., 56(6), 1875-1881.
}
\seealso{
Other growth models: \code{\link{grow_baranyi}},
  \code{\link{grow_exponential}},
  \code{\link{grow_gompertz}}, \code{\link{grow_huang}},
  \code{\link{grow_logistic}}, \code{\link{grow_richards}},
  \code{\link{growthmodel}}, \code{\link{ode_genlogistic}},
  \code{\link{ode_twostep}}
}
\concept{growth models}
