% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{posieux_weather}
\alias{posieux_weather}
\title{Example Weather Data}
\format{
A data.frame with 3652 rows and 10 variables:
\describe{
\item{year}{Year as an integer}
\item{DOY}{Day of year as an integer}
\item{Ta}{Average temperature of the day in degree Celsius}
\item{Tmin}{Minimum temperature of the day in degree Celsius}
\item{Tmax}{Maximum temperature of the day in degree Celsius}
\item{precip}{Daily precipitation in mm}
\item{rSSD}{Relative sunshine duration in percent}
\item{SRad}{Sun irradiance in J / s / m^2. This can be converted into
photosynthetically active radiation (PAR) in MJ / m^2 as:
PAR = SRad * 0.47 * 24 * 60 * 60 / 1e6}
\item{ET0}{Evapotranspiration in mm.}
\item{snow}{Precipitation in the form of snow in mm}
}
}
\usage{
posieux_weather
}
\description{
Datasets containing the weather input parameters as used by growR. The
same data is made available as plain text files by the package and
automatically found in the \code{input} directory created by \code{\link[=setup_directory]{setup_directory()}}
if the \code{include_examples} option is set to \code{TRUE} (default).
}
\details{
For use in growR, a \link{WeatherData} object has to be created from a plain
text file. Therefore, this dataset is only provided for convenient
inspection. In order to run growR, use the plain text files provided by
the package. Use \code{system.file("extdata", package = "growR")} to locate them.

The \emph{snow} column is not actually used by growR but rather calculated
through precipitation and temperatures in \link{WeatherData}\verb{$read_weather()}.

Likewise, the \emph{rSSD} column is deprecated, currently unused and only kept
for backwards compatibility.
}
\seealso{
\code{\link[=setup_directory]{setup_directory()}}, \link{WeatherData}
}
\keyword{datasets}
