% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinator.R
\name{Combinator}
\alias{Combinator}
\title{Combinator}
\description{
Helps to find all possible combinations for a given set of values.
}
\seealso{
\code{\link[=create_combinations]{create_combinations()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{combinations}}{list Once run, holds all valid parameter combinations
as named lists.}

\item{\code{eps}}{float Numerical precision to require when checking the
functional group weight sum criterion.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Combinator-create_combinations}{\code{Combinator$create_combinations()}}
\item \href{#method-Combinator-clone}{\code{Combinator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Combinator-create_combinations"></a>}}
\if{latex}{\out{\hypertarget{method-Combinator-create_combinations}{}}}
\subsection{Method \code{create_combinations()}}{
Find possible combinations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Combinator$create_combinations(param_values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_values}}{A list giving all options for the parameter values
which are to be combined. As an example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(w_FGA = c(0, 0.5, 1), w_FGB = c(0, 0.5, 1), NI = c(0.5, 0.9))
}\if{html}{\out{</div>}}

This would generate the combinations\tabular{lll}{
   w_FGA \tab w_FGB \tab NI \cr
   0 \tab 1 \tab 0.5 \cr
   0 \tab 1 \tab 0.9 \cr
   0.5 \tab 0.5 \tab 0.5 \cr
   0.5 \tab 0.5 \tab 0.9 \cr
   1 \tab 0 \tab 0.5 \cr
   1 \tab 0 \tab 0.9 \cr
}}

\item{\code{eps}}{Precision to be used when checking if the sum citerion of the
functional groups (w_FGA + w_FGB + w_FGC + w_FGD = 1) is fulfilled.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
combinations A list containing vectors of parameter value
combinations.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Combinator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Combinator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Combinator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
