\name{gcFit}
\Rdversion{1.1}
\alias{gcFit}
\title{
Function to run growth curve fitting on several data sets containing growth data.
}
\description{
The function serves to estimate several growth curves at once. The function calls the functions \code{\link{gcFitSpline}}, \code{\link{gcFitModel}} and \code{\link{gcBootSpline}} to generate  estimates for growth parameters and respecting statistics.
}
\usage{
gcFit(time, data, control = grofit.control())
}
\arguments{
  \item{time}{
Numeric matrix, consisting of n columns for the time points and m rows for the different experiments.
}
  \item{data}{
Data frame consisting of 3+n columns, containing three coulumns of additional information and n columns of growth data corresponding to \code{time}. Format convention: 1. column, character as an experiment identifier; 2. column: character, additional information about respecting experiment; 3. column: concentration of substrate of a compound under which the experiment is obtained; 4.-(n+3). column: growth data corresponding to the time points in \code{time}.
}
  \item{control}{
Object of class \code{grofit.control} containing a list of options generated by the function \code{\link{grofit.control}}.
}
}
\value{
Generates an object of class \code{gcFit}
\item{raw.time}{Raw time passed to the function as \code{time}.}
\item{raw.data}{Raw time passed to the function as \code{data}.}
\item{gcTable}{Table with characteristic growth values and related statistics related for each growth curve data provided to the function. This table, which is also returned by the generic \code{\link{summary.gcFit}} method applied to an \code{gcFit} object, is used as an input for \code{\link{drFit}}. 1. column: character, naming the experiment; 2. column: logical, indicating wether a logarithmic transformation was applied to concentration data; 3. column, logical, indicating wether a logarithmic transformation was applied to growth parameter; 4. column, numeric, number of bootstrap samples used; 5.-8. column: numeric, estimated EC50 value and respecting reponse value (5.-6.), also in original scale if a transformation is applied (7.-8.); 9.-10. column: numeric, mean and standard dev. from bootstrap sample; 11.-14. column: 90 and 95 percent confidence interval from bootstrap sample; 15. column: mean EC50 of bootstrap sample in original scale; 16.-19. 90 and 95 percent confidence interval in original scale.}
\item{gcFittedModels}{All \code{gcFitModel} objects, generated by the call of \code{\link{gcFitModel}}. Note: access to each object via double brace: gcFittedModels[[#n]].}
\item{gcFittedSplines}{All \code{gcFitSpline} objects, generated by the call of \code{\link{gcFitSpline}}. Note: access to each object via double brace: gcFittedSplines[[#n]].}
\item{gcBootSplines}{All \code{gcFitSpline} objects, generated by the call of \code{\link{gcFitSpline}}. Note: access to each object via double brace: gcFittedSplines[[#n]].}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\seealso{
\code{\link{grofit}}, \code{\link{grofit.time}}, \code{\link{grofit.data}}, \code{\link{ran.data}} , \code{\link{summary.gcFit}}, \code{\link{plot.gcFit}}
}
\examples{
# generate random growth curve data sets,
# fulfilling the conventions described in arguments
foo <- ran.data(100, 25)
time <- foo$time
data <- foo$data
# fit dose response curves
result <- gcFit(time,data, control=grofit.control(fit.opt="b"))
print(summary(result))
plot(result)
}
