% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridpattern-package.R
\docType{package}
\name{gridpattern-package}
\alias{gridpattern}
\alias{gridpattern-package}
\title{gridpattern: 'grid' Pattern Grobs}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Provides 'grid' grobs that fill in a user-defined area with various patterns. Includes enhanced versions of the geometric and image-based patterns originally contained in the 'ggpattern' package as well as original 'pch', 'polygon_tiling', 'regular_polygon', 'rose', 'text', 'wave', and 'weave' patterns plus support for custom user-defined patterns.
}
\section{Package options}{

The following \code{gridpattern} options may be set globally via \code{\link[base:options]{base::options()}}:
\describe{
\item{ggpattern_array_funcs}{Set custom \dQuote{array} pattern functions.}
\item{ggpattern_geometry_funcs}{Set custom \dQuote{geometry} pattern functions.}
\item{ggpattern_res}{Set custom raster image resolution (pixels per inch) for certain patterns.}
\item{ggpattern_use_R4.1_clipping}{If \code{TRUE} use the grid clipping path feature introduced in R v4.1.0.
If \code{FALSE} do a \code{rasterGrob} approximation of the clipped pattern.
If \code{NULL} try to guess an appropriate choice.}
\item{ggpattern_use_R4.1_features}{If \code{TRUE} sets the default for all the other
\verb{ggpattern_use_R4.1_*} options arguments to \code{TRUE}.
If \code{FALSE} sets them to \code{FALSE}.}
\item{ggpattern_use_R4.1_gradients}{If \code{TRUE} use the grid gradient feature introduced in R v4.1.0.
If \code{FALSE} do a \code{rasterGrob} approximation of the gradient pattern.
If \code{NULL} try to guess an appropriate choice.}
\item{ggpattern_use_R4.1_masks}{If \code{TRUE} use the grid mask feature introduced in R v4.1.0.
If \code{FALSE} do a \code{rasterGrob} approximation of the masked pattern.
If \code{NULL} try to guess an appropriate choice.}
\item{ggpattern_use_R4.1_patterns}{If \code{TRUE} use the grid pattern feature introduced in R v4.1.0.
Currently only used by a couple of examples.}
}
Note to use the R v4.1.0 features one needs R be (at least) version 4.1 and not all graphic devices
support any/all these features.  See \url{https://www.stat.auckland.ac.nz/~paul/Reports/GraphicsEngine/definitions/definitions.html} for more information on these features.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://trevorldavis.com/R/gridpattern/}
  \item \url{https://github.com/trevorld/gridpattern}
  \item Report bugs at \url{https://github.com/trevorld/gridpattern/issues}
}

}
\author{
\strong{Maintainer}: Trevor L. Davis \email{trevor.l.davis@gmail.com} (\href{https://orcid.org/0000-0001-6341-4639}{ORCID})

Authors:
\itemize{
  \item Mike FC (Code/docs adapted from ggpattern)
}

Other contributors:
\itemize{
  \item ggplot2 authors (some utility functions copied from ggplot2) [contributor]
}

}
