% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{association}
\alias{association}
\alias{assoc}
\title{Measures of association}
\usage{
association(x, y = NULL, use = c("na.or.complete", "complete.obs",
  "everything", "all.obs"), method = c("auto", "pearson", "spearman",
  "kendall", "cramer"))

assoc(x, y = NULL, use = c("na.or.complete", "complete.obs", "everything",
  "all.obs"), method = c("auto", "pearson", "spearman", "kendall", "cramer"))
}
\arguments{
\item{x}{Either data.frame or a matrix}

\item{y}{The numerical variable.}

\item{use}{What observations to use. See \link[stats]{cor} function for details.
The only option that is not available here is \code{"pairwise.complete.obs"}.}

\item{method}{Which method to use for the calculation of measures of association.
By default this is \code{"auto"}, which means that the function will use:
\link[stats]{cor}, \link[greybox]{mcor} or \link[greybox]{cramer} - depending on
the scales of variables. The other options force the function to use one and
the same method for all the variables:
\itemize{
\item \code{"pearson"} - Pearson's correlation coefficient using \link[stats]{cor};
\item \code{"spearman"} - Spearman's correlation coefficient based on \link[stats]{cor};
\item \code{"kendall"} - Kendall's correlation coefficient via \link[stats]{cor};
\item \code{"cramer"} - Cramer's V using \link[greybox]{cramer};
}
Be aware that the wrong usage of measures of association might give misleading results.}
}
\value{
The following list of values is returned:
\itemize{
\item{value - Matrix of the coefficients of association;}
\item{p.value - The p-values for the parameters;}
\item{type - The matrix of the types of measures of association.}
}
}
\description{
Function returns the matrix of measures of association for different types of
variables.
}
\details{
The function looks at the types of the variables and calculates different
measures depending on the result:
\itemize{
\item If both variables are numeric, then Pearson's correlation is calculated;
\item If both variables are categorical, then Cramer's V is calculated;
\item Finally, if one of the variables is categorical, and the other is numeric,
then multiple correlation is returned.
}
After that the measures are wrapped up in a matrix.

Function also calculates the p-values associated with the respective measures
(see the return).

See details in the vignette "Marketing analytics with greybox":
\code{vignette("maUsingGreybox","greybox")}

\code{assoc()} is just a short name for the \code{association{}}.
}
\examples{

association(mtcars)

}
\seealso{
\code{\link[base]{table}, \link[greybox]{tableplot}, \link[greybox]{spread},
\link[greybox]{cramer}, \link[greybox]{mcor}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{htest}
