% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaler.R
\name{sm}
\alias{sm}
\alias{sm.default}
\alias{sm.lm}
\alias{sm.alm}
\title{Scale Model}
\usage{
sm(object, ...)

\method{sm}{default}(object, formula = NULL, data = NULL,
  parameters = NULL, ...)

\method{sm}{lm}(object, formula = NULL, data = NULL, parameters = NULL,
  ...)

\method{sm}{alm}(object, formula = NULL, data = NULL, parameters = NULL,
  ...)
}
\arguments{
\item{object}{The pre-estimated \code{alm} or \code{lm} model.}

\item{...}{Other parameters to pass to the method, including those explained in
\link[greybox]{alm} (e.g. parameters for optimiser).}

\item{formula}{The formula for scale. It should start with ~ and contain all variables
that should impact the scale.}

\item{data}{The data, on which the scale model needs to be estimated. If not provided,
then the one used in the \code{object} is used.}

\item{parameters}{The parameters to use in the model. Only needed if you know the parameters
in advance or want to test yours.}
}
\description{
This method produces a model for scale of distribution for the provided pre-estimated model.
The model can be estimated either via \code{lm} or \code{alm}.
}
\details{
This function is useful, when you suspect a heteroscedasticity in your model and want to
fit a model for the scale of the pre-specified distribution. This function is complementary
for \code{lm} or \code{alm}.
}
\examples{

xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+sqrt(exp(0.8+0.2*xreg[,1]))*rnorm(100,0,1),
              xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

# Estimate the location model
ourModel <- alm(y~.,xreg)
# Estimate the scale model
ourScale <- sm(ourModel,formula=~x1+x2)
# Summary of the scale model
summary(ourScale)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
