% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Malliavin_Asian_Greeks.R
\name{Malliavin_Asian_Greeks}
\alias{Malliavin_Asian_Greeks}
\title{Computes the Greeks of an Asian option with the Malliavin Monte Carlo
Method in the Black Scholes model, or for Asian options, also in a Jump
Diffusion model}
\usage{
Malliavin_Asian_Greeks(
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  volatility = 0.3,
  dividend_yield = 0,
  payoff = "call",
  greek = c("fair_value", "delta", "rho", "vega", "theta", "gamma"),
  model = "black_scholes",
  lambda = 0.2,
  alpha = 0.3,
  jump_distribution = function(n) stats::rt(n, df = 3),
  steps = round(time_to_maturity * 252),
  paths = 10000,
  seed = 1,
  antithetic = FALSE
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset, can also be a
vector
}}

\item{exercise_price}{\itemize{
\item strike price of the option, can also be a vector
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity in years
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{payoff}{\itemize{
\item the payoff function, either a string in ("call", "put",
"digital_call", "digital_put"), or a function
}}

\item{greek}{\itemize{
\item the Greek to be calculated
}}

\item{model}{\itemize{
\item the model to be chosen in ("black_scholes", "jump_diffusion")
}}

\item{lambda}{\itemize{
\item the lambda of the Poisson process in the jump-diffusion model
}}

\item{alpha}{\itemize{
\item the alpha in the jump-diffusion model influences the jump size
}}

\item{jump_distribution}{\itemize{
\item the distribution of the jumps, choose a function
which generates random numbers with the desired distribution
}}

\item{steps}{\itemize{
\item the number of integration steps
}}

\item{paths}{\itemize{
\item the number of simulated paths
}}

\item{seed}{\itemize{
\item the seed of the random number generator
}}

\item{antithetic}{\itemize{
\item if TRUE, antithetic random numbers will be chosen to
decrease variance
}}
}
\value{
Named vector containing the values of the Greeks specified in the
parameter \code{greek}.
}
\description{
Asian options are path-dependent.
If \eqn{S_t} is the price of the underlying asset at time \eqn{t}, the
execution of an Asian option depends on the average price of option,
\eqn{\frac{1}{T} \int_0^T S_t dt}, where \eqn{T} is the time-to-maturity of
the option.
For more details on the definition of Greeks in general see \link{Greeks}.

For a description of Malliavin Monte Carlo Methods for Greeks see for example
(Hudde & Rüschendorf, 2023).
}
\examples{
Malliavin_Asian_Greeks(initial_price = 110, exercise_price = 100,
r = 0.02, time_to_maturity = 4.5, dividend_yield = 0.015, volatility = 0.22,
greek = c("fair_value", "delta", "rho"), payoff = "put")

}
\references{
Hudde, A., & Rüschendorf, L. (2023). European and Asian Greeks for Exponential Lévy Processes. Methodol Comput Appl Probab, 25 (39). \doi{10.1007/s11009-023-10014-5}
}
\seealso{
\link{BS_Malliavin_Asian_Greeks} for a faster computation, but only in
the Black Scholes model and with a smaller set of Greeks
}
