% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{calculate_distance}
\alias{calculate_distance}
\title{Calculate distance between sample data before and after registration}
\usage{
calculate_distance(results, type = c("registered", "all"), genes_list = NULL)
}
\arguments{
\item{results}{Result of registration process using \code{\link[=register]{register()}}.}

\item{type}{Whether to calculate distance considering only "registered" genes (default) or "all" genes.}

\item{genes_list}{Optional vector indicating the \code{gene_id} values to be considered.}
}
\value{
This function returns a \code{dist_greatR} object containing two data frames:

\item{registered}{pairwise distance between scaled reference and query expressions using registered time points.}
\item{original}{pairwise distance between scaled reference and query expressions using original time points.}
}
\description{
\code{calculate_distance()} is a function that allows users to calculate
pairwise distances between samples from different time points to
investigate the similarity of progression before or after registration.
}
