% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{register}
\alias{register}
\title{Register or synchronize different expression profiles}
\usage{
register(
  input,
  stretches = NA,
  shifts = NA,
  reference,
  query,
  scaling_method = c("scale", "normalise"),
  overlapping_percent = 0.5,
  optimise_registration_parameters = TRUE,
  optimisation_method = c("nm", "lbfgsb", "sa"),
  optimisation_config = NULL
)
}
\arguments{
\item{input}{Input data frame containing all replicates of gene expression in each genotype at each time point.}

\item{stretches}{Candidate registration stretch factors to apply to query data, only required if \code{optimise_registration_parameters = FALSE}.}

\item{shifts}{Candidate registration shift values to apply to query data, only required if \code{optimise_registration_parameters = FALSE}.}

\item{reference}{Accession name of reference data.}

\item{query}{Accession name of query data.}

\item{scaling_method}{Scaling method applied to data prior to registration process. Either \code{scale} (default), or \code{normalise}.}

\item{overlapping_percent}{Number of minimum overlapping time points. Shifts will be only considered if it leaves at least these many overlapping points after applying the registration function.}

\item{optimise_registration_parameters}{Whether to optimise registration parameters with Simulated Annealing. By default, \code{TRUE}.}

\item{optimisation_method}{Optimisation method to use. Either \code{"nm"} for Nelder-Mead (default), \code{"lbfgsb"} for L-BFGS-B, or \code{"sa"} for Simulated Annealing.}

\item{optimisation_config}{Optional list with arguments to override the default optimisation configuration.}
}
\value{
This function returns a list of data frames, containing:

\item{data}{a table containing the scaled input data and an additional \code{timepoint_reg} column after applying registration parameters to the query data.}
\item{model_comparison}{a table comparing the optimal registration function for each gene (based on \code{all_shifts_df} scores) to model with no registration applied.}
}
\description{
\code{register()} is a function to register expression profiles a user
wishes to compare.
}
\examples{
\dontrun{
# Load a data frame from the sample data
data_path <- system.file("extdata/brapa_arabidopsis_all_replicates.csv", package = "greatR")
all_data <- utils::read.csv(data_path)

# Running the registration
registration_results <- register(
  input = all_data,
  reference = "Ro18",
  query = "Col0"
)
}
}
