% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_business_tax_offset.R
\name{small_business_tax_offset}
\alias{small_business_tax_offset}
\title{Small Business Tax Offset}
\source{
Basic income tax method s4-10(3) \url{http://classic.austlii.edu.au/au/legis/cth/consol_act/itaa1997240/s4.10.html}.
Explanatory memorandum \url{https://github.com/HughParsonage/grattan/blob/master/data-raw/parlinfo/small-biz-explanatory-memo-2015.pdf} from the original \verb{http://parlinfo.aph.gov.au/parlInfo/download/legislation/ems/r5494_ems_0a26ca86-9c3f-4ffa-9b81-219ac09be454/upload_pdf/503041.pdf}.
}
\usage{
small_business_tax_offset(
  taxable_income,
  basic_income_tax_liability,
  .dots.ATO = NULL,
  aggregated_turnover = NULL,
  total_net_small_business_income = NULL,
  fy_year = NULL,
  tax_discount = NULL
)
}
\arguments{
\item{taxable_income}{Individual's assessable income.}

\item{basic_income_tax_liability}{Tax liability (in dollars) according to the method in the box in s 4.10(3) of the \emph{Income Tax Assessment Act 1997} (Cth). In general, \code{basic_income_tax_liability} is the ordinary tax minus offsets. In particular, it does not include levies (such as the Medicare levy or the Temporary Budget Repair Levy). 
\if{latex}{\deqn{\mathrm{Income\;Tax} = \mathrm{Taxable\;income\times\mathrm{Rate}-\mathrm{Tax\;offsets}}}}
For example, in 2015-16, an individual with an assessable income of 100,000 had a basic tax liability of 
approximately 25,000.}

\item{.dots.ATO}{A \code{data.table} of tax returns.
If provided, it must contain the variables
 \code{Total_PP_BE_amt},
 \code{Total_PP_BI_amt},
 \code{Total_NPP_BE_amt},
 \code{Total_NPP_BI_amt}.
If both \code{.dots.ATO} and either \code{aggregated_turnover} or \code{total_net_small_business_income} are provided, 
\code{.dots.ATO} takes precedence, with a warning.

If \code{.dots.ATO} contains the variable \code{Tot_net_small_business_inc}, it is used instead of the income variables.}

\item{aggregated_turnover}{A numeric vector the same length as \code{taxable_income}.
Only used to determine whether or not the offset is applicable; that is, the offset only
applies if aggregated turnover is less than 2 million.

Aggregated turnover of a taxpayer is the sum of the following:
\itemize{
\item{the taxpayer's annual turnover for the income year,}
\item{the annual turnover of any entity connected with the taxpayer's, for that part of the income year that the entity is connected with the taxpayer's}
\item{the annual turnover of any entity that is an affiliate of the taxpayer, for that part of the income year that the entity is affiliated with the taxpayer's}
\item{When you calculate aggregated turnover for an income year, do not include either:}
\itemize{
\item{the annual turnover of other entities for any period of time that the entities are either not connected with the taxpayer or are not the taxpayer's affiliate, or}
\item{amounts resulting from any dealings between these entities for that part of the income year that the entity is connected or affiliated with the taxpayer.}
}
}
\url{https://www.ato.gov.au/Business/Research-and-development-tax-incentive/Claiming-the-tax-offset/Steps-to-claiming-the-tax-offset/Step-3---Calculate-your-aggregated-turnover/}}

\item{total_net_small_business_income}{Total net business income within the meaning of the Act. For most taxpayers, this is simply any net income from a business they own (or their share of net income from a business in which they have an interest). The only difference being in the calculation of the net business income of some minors (vide Division 6AA of Part III of the Act).}

\item{fy_year}{The financial year for which the small business tax offset is to apply.}

\item{tax_discount}{If you do not wish to use the legislated discount rate from a particular \code{fy_year}, 
you can specify it via \code{tax_discount}. If both are provided, \code{tax_discount} prevails, with a warning.}
}
\description{
Small Business Tax Offset
}
