% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_income_tax.R
\name{model_income_tax}
\alias{model_income_tax}
\title{Modelled Income Tax}
\usage{
model_income_tax(sample_file, baseline_fy, n_dependants = 0L,
  elasticity_of_taxable_income = NULL, ordinary_tax_thresholds = NULL,
  ordinary_tax_rates = NULL, medicare_levy_taper = NULL,
  medicare_levy_rate = NULL, medicare_levy_lower_threshold = NULL,
  medicare_levy_upper_threshold = NULL,
  medicare_levy_lower_sapto_threshold = NULL,
  medicare_levy_upper_sapto_threshold = NULL,
  medicare_levy_lower_family_threshold = NULL,
  medicare_levy_upper_family_threshold = NULL,
  medicare_levy_lower_family_sapto_threshold = NULL,
  medicare_levy_upper_family_sapto_threshold = NULL,
  medicare_levy_lower_up_for_each_child = NULL, lito_max_offset = NULL,
  lito_taper = NULL, lito_min_bracket = NULL, lito_multi = NULL,
  Budget2018_lamington = FALSE, Budget2018_lito_202223 = FALSE,
  Budget2018_watr = FALSE, sapto_eligible = NULL,
  sapto_max_offset = NULL, sapto_lower_threshold = NULL,
  sapto_taper = NULL, sapto_max_offset_married = NULL,
  sapto_lower_threshold_married = NULL, sapto_taper_married = NULL,
  sbto_discount = NULL, cgt_discount_rate = NULL,
  calc_baseline_tax = TRUE, return. = c("sample_file", "tax",
  "sample_file.int"), clear_tax_cols = TRUE,
  warn_upper_thresholds = TRUE, .debug = FALSE)
}
\arguments{
\item{sample_file}{A sample file having at least as many variables as the 2012-13 sample file.}

\item{baseline_fy}{If a parameter is not selected, the parameter's value in this tax year is used.

Must be a valid tax year and one for which \code{income_tax} has been programmed.}

\item{n_dependants}{The number of dependants for each entry in \code{sample_file}.}

\item{elasticity_of_taxable_income}{Either \code{NULL} (the default), or a numeric vector the same length of \code{sample_file} (or length-1) providing the elasticity of taxable income for each observation in \code{sample_file}; 
\deqn{\frac{\Delta z / z}{\Delta \tau / (1 - \tau)}} 
where \eqn{z} is taxable income and \eqn{\tau} is tax payable.

For example, if, for a given taxpayer,
the tax settings would otherwise result in a 2\% decrease of disposable income
under the tax settings to be modelled, and \code{elasticity_of_taxable_income} is set to 0.1,
the \code{Taxable_Income} is reduced by 0.2\% before the tax rates are applied.

If \code{NULL}, an elasticity of 0 is used.}

\item{ordinary_tax_thresholds}{A numeric vector specifying the lower bounds of the brackets for "ordinary tax" as defined by the Regulations.
The first element should be zero if there is a tax-free threshold.}

\item{ordinary_tax_rates}{The marginal rates of ordinary tax. The first element should be zero if there is a tax-free threshold. 
Since the temporary budget repair levy was imposed on a discrete tax bracket when it applied, it is not included in this function.}

\item{medicare_levy_taper}{The taper that applies between the \code{_lower} and \code{_upper} thresholds.}

\item{medicare_levy_rate}{The ordinary rate of the Medicare levy for taxable incomes above \code{medicare_levy_upper_threshold}.}

\item{medicare_levy_lower_threshold}{Minimum taxable income at which the Medicare levy will be applied.}

\item{medicare_levy_upper_threshold}{Minimum taxable income at which the Medicare levy will be applied at the full Medicare levy rate (2\% in 2015-16). Between this threshold and the \code{medicare_levy_lower_threshold}, a tapered rate applies, starting from zero and climbing to \code{medicare_levy_rate}.}

\item{medicare_levy_lower_sapto_threshold, medicare_levy_upper_sapto_threshold}{The equivalent values for SAPTO-eligible individuals (not families).}

\item{medicare_levy_lower_family_threshold, medicare_levy_upper_family_threshold}{The equivalent values for families.}

\item{medicare_levy_lower_family_sapto_threshold, medicare_levy_upper_family_sapto_threshold}{The equivalent values for SAPTO-eligible individuals in a family.}

\item{medicare_levy_lower_up_for_each_child}{The amount to add to the \code{_family_threshold}s for each dependant child.}

\item{lito_max_offset}{The maximum offset available for low incomes.}

\item{lito_taper}{The taper to apply beyond \code{lito_min_bracket}.}

\item{lito_min_bracket}{The taxable income at which the value of the offset starts to reduce (from \code{lito_max_offset}).}

\item{lito_multi}{A list of two components, named \code{x} and \code{y}, giving the value of a \emph{replacement} for \code{lito} at specified points, which will be linked by a piecewise linear curve between the points specified. For example, to mimic LITO in 2015-16 (when the offset was \$445 for incomes below \$37,000, and afterwards tapered off to \$66,667), one would use \code{lito_multi = list(x = c(-Inf, 37e3, 200e3/3, Inf), y = c(445, 445, 0, 0))}. The reason the argument ends with \code{multi} is that it is intended to extend the original parameters of LITO so that multiple kinks (including ones of positive and negative gradients) can be modelled.}

\item{Budget2018_lamington}{The Low Middle Income Tax Offset proposed in the 2018 Budget.}

\item{Budget2018_lito_202223}{The LITO proposed for 2022-23 proposed in the 2018 Budget.}

\item{Budget2018_watr}{The "Working Australian Tax Refund" proposed in the Opposition Leader's Budget Reply Speech 2018.}

\item{sapto_eligible}{Whether or not each taxpayer in \code{sample_file} is eligible for \code{SAPTO}. 
If \code{NULL}, the default, then eligibility is determined by \code{age_range} in \code{sample_file};
\emph{i.e.}, if \code{age_range <= 1} then the taxpayer is assumed to be eligible for SAPTO.}

\item{sapto_max_offset}{The maximum offset available through SAPTO.}

\item{sapto_lower_threshold}{The threshold at which SAPTO begins to reduce (from \code{sapto_max_offset}).}

\item{sapto_taper}{The taper rate beyond \code{sapto_lower_threshold}.}

\item{sapto_max_offset_married, sapto_lower_threshold_married, sapto_taper_married}{As above,
but applied to members of a couple}

\item{sbto_discount}{The \code{tax_discount} in \code{\link{small_business_tax_offset}}.}

\item{cgt_discount_rate}{(numeric(1)) The capital gains tax discount rate, currently 50\%.}

\item{calc_baseline_tax}{(logical, default: \code{TRUE}) Should the income tax in \code{baseline_fy} be included as a column in the result?}

\item{return.}{What should the function return? One of \code{tax}, \code{sample_file}, or \code{sample_file.int}. 
If \code{tax}, the tax payable under the settings; if \code{sample_file}, the \code{sample_file},
but with variables \code{tax} and possibly \code{new_taxable_income}; if \code{sample_file.int}, same as \code{sample_file} but \code{new_tax} is coerced to integer.}

\item{clear_tax_cols}{If \code{TRUE}, the default, then \code{return. = sample_file} implies any columns called \code{new_tax} or \code{baseline_tax} in \code{sample_file} are dropped silently.}

\item{warn_upper_thresholds}{If \code{TRUE}, the default, then any inconsistency between \code{baseline_fy} and the upper thresholds result in a warning. Set to \code{FALSE}, if the \code{lower_threshold}s may take priority.}

\item{.debug}{Return a data.table of \code{new_tax}. Experimental so cannot be relied in future versions.}
}
\description{
The income tax payable if tax settings are changed.
}
\examples{

library(data.table)
library(hutils)

# With new tax-free threshold of $20,000:
if (requireNamespace("taxstats", quietly = TRUE)) {
  library(taxstats)
  library(magrittr)
     
  model_income_tax(sample_file_1314,
                   "2013-14",
                   ordinary_tax_thresholds = c(0, 20e3, 37e3, 80e3, 180e3)) \%>\%
    select_grep("tax", "Taxable_Income")

}

}
