% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentially_uprate_wage.R
\name{differentially_uprate_wage}
\alias{differentially_uprate_wage}
\title{Differential uprating}
\usage{
differentially_uprate_wage(wage = 1, from_fy, to_fy, ...)
}
\arguments{
\item{wage}{A numeric vector to be uprated.}

\item{from_fy}{The financial year contemporaneous to wage, which must be a financial year of an available sample file -- in particular, not after 2013-14.}

\item{to_fy}{The target of the uprating. Passed to \code{\link{wage_inflator}}.}

\item{...}{Other arguments passed \code{\link{wage_inflator}}.}
}
\value{
The vector \code{wage} differentially uprated to \code{to_fy}.
}
\description{
Apply differential uprating to projections of the \code{Sw_amt} variable.
}
\details{
See \code{vignette("differential-uprating")}.
}
\examples{
ws <- c(20e3, 50e3, 100e3)
from <- "2013-14"
to <- "2016-17"
differentially_uprate_wage(ws, from, to)
differentially_uprate_wage(ws, from, to) / wage_inflator(ws, from, to)
}
\author{
Hugh Parsonage and William Young
}

