% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior-samples.R
\name{smooth_samples}
\alias{smooth_samples}
\alias{smooth_samples.gam}
\title{Posterior draws for individual smooths}
\usage{
smooth_samples(model, ...)

\method{smooth_samples}{gam}(
  model,
  select = NULL,
  term = deprecated(),
  n = 1,
  data = newdata,
  method = c("gaussian", "mh", "inla", "user"),
  seed = NULL,
  freq = FALSE,
  unconditional = FALSE,
  n_cores = 1L,
  n_vals = 200,
  burnin = 1000,
  thin = 1,
  t_df = 40,
  rw_scale = 0.25,
  rng_per_smooth = FALSE,
  draws = NULL,
  partial_match = NULL,
  ...,
  newdata = NULL,
  ncores = NULL
)
}
\arguments{
\item{model}{a fitted model of the supported types}

\item{...}{arguments passed to other methods. For \code{fitted_samples()}, these
are passed on to \code{\link[=predict.gam]{predict.gam()}}. For \code{posterior_samples()} these are
passed on to \code{fitted_samples()}. For \code{predicted_samples()} these are
passed on to the relevant \code{simulate()} method.}

\item{select}{character; select which smooth's posterior to draw from.
The default (\code{NULL}) means the posteriors of all smooths in \code{model}
wil be sampled from. If supplied, a character vector of requested terms.}

\item{term}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{select} instead.}

\item{n}{numeric; the number of posterior samples to return.}

\item{data}{data frame; new observations at which the posterior draws
from the model should be evaluated. If not supplied, the data used to fit
the model will be used for \code{data}, if available in \code{model}.}

\item{method}{character; which method should be used to draw samples from
the posterior distribution. \code{"gaussian"} uses a Gaussian (Laplace)
approximation to the posterior. \code{"mh"} uses a Metropolis Hastings sampler
that alternates t proposals with proposals based on a shrunken version of
the posterior covariance matrix. \code{"inla"} uses a variant of Integrated
Nested Laplace Approximation due to Wood (2019), (currently not
implemented). \code{"user"} allows for user-supplied posterior draws
(currently not implemented).}

\item{seed}{numeric; a random seed for the simulations.}

\item{freq}{logical; \code{TRUE} to use the frequentist covariance matrix of
the parameter estimators, \code{FALSE} to use the Bayesian posterior
covariance matrix of the parameters.}

\item{unconditional}{logical; if \code{TRUE} (and \code{freq == FALSE}) then the
Bayesian smoothing parameter uncertainty corrected covariance matrix is
used, if available.}

\item{n_cores}{number of cores for generating random variables from a
multivariate normal distribution. Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}.
Parallelization will take place only if OpenMP is supported (but appears
to work on Windows with current \code{R}).}

\item{n_vals}{numeric; how many locations to evaluate the smooth at if
\code{data} not supplied}

\item{burnin}{numeric; number of samples to discard as the burnin draws.
Only used with \code{method = "mh"}.}

\item{thin}{numeric; the number of samples to skip when taking \code{n} draws.
Results in \code{thin * n} draws from the posterior being taken. Only used with
\code{method = "mh"}.}

\item{t_df}{numeric; degrees of freedome for t distribution proposals. Only
used with \code{method = "mh"}.}

\item{rw_scale}{numeric; Factor by which to scale posterior covariance
matrix when generating random walk proposals. Negative or non finite to
skip the random walk step. Only used with \code{method = "mh"}.}

\item{rng_per_smooth}{logical; if TRUE, the behaviour of gratia version
0.8.1 or earlier is used, whereby a separate call the the random number
generator (RNG) is performed for each smooth. If FALSE, a single call to the
RNG is performed for all model parameters}

\item{draws}{matrix; user supplied posterior draws to be used when
\code{method = "user"}.}

\item{partial_match}{logical; should smooths be selected by partial matches
with \code{select}? If \code{TRUE}, \code{select} can only be a single string to match
against.}

\item{newdata}{Deprecated: use \code{data} instead.}

\item{ncores}{Deprecated; use \code{n_cores} instead. The number of cores for
generating random variables from a multivariate normal distribution.
Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}. Parallelization will take place only if
OpenMP is supported (but appears to work on Windows with current \code{R}).}
}
\value{
A tibble with additional classes \code{"smooth_samples"} and
`"posterior_samples".

For the \code{"gam"} method, the columns currently returned (not in this order)
are:
\itemize{
\item \code{.smooth}; character vector. Indicates the smooth function for that
particular draw,
\item \code{.term}; character vector. Similar to \code{smooth}, but will contain the
full label for the smooth, to differentiate factor-by smooths for
example.
\item \code{.by}; character vector. If the smooth involves a \code{by} term, the
by variable will be named here, \code{NA_character_} otherwise.
\item \code{.row}; integer. A vector of values \code{seq_len(n_vals)}, repeated if
\code{n > 1L}. Indexes the row in \code{data} for that particular draw.
\item \code{.draw}; integer. A vector of integer values indexing the particular
posterior draw that each row belongs to.
\item \code{.value}; numeric. The value of smooth function for this posterior draw
and covariate combination.
\item \code{xxx}; numeric. A series of one or more columns containing data required
for the smooth, named as per the variables involved in the respective
smooth.
\item Additional columns will be present in the case of factor by smooths,
which will contain the level for the factor named in \code{by_variable} for
that particular posterior draw.
}
}
\description{
Returns draws from the posterior distributions of smooth functions in a GAM.
Useful, for example, for visualising the uncertainty in individual estimated
functions.
}
\section{Warning}{

The set of variables returned and their order in the tibble is subject to
change in future versions. Don't rely on position.
}

\examples{
load_mgcv()
\dontshow{
op <- options(cli.unicode = FALSE, pillar.sigfig = 3)
}
dat <- data_sim("eg1", n = 400, seed = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

sms <- smooth_samples(m1, select = "s(x0)", n = 5, seed = 42)
\donttest{
sms
}

## A factor by example (with a spurious covariate x0)
dat <- data_sim("eg4", n = 1000, seed = 2)

## fit model...
m2 <- gam(y ~ fac + s(x2, by = fac) + s(x0), data = dat)
sms <- smooth_samples(m2, n = 5, seed = 42)
draw(sms)
\dontshow{
options(op)
}
}
\author{
Gavin L. Simpson
}
