% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis-funs.R
\name{basis}
\alias{basis}
\alias{basis.gam}
\alias{basis.scam}
\alias{basis.gamm}
\alias{basis.list}
\alias{basis.default}
\title{Basis expansions for smooths}
\usage{
basis(object, ...)

\method{basis}{gam}(
  object,
  term = NULL,
  data = NULL,
  n = 100,
  n_2d = 50,
  n_3d = 16,
  n_4d = 4,
  partial_match = FALSE,
  ...
)

\method{basis}{scam}(
  object,
  term = NULL,
  data = NULL,
  n = 100,
  n_2d = 50,
  n_3d = 16,
  n_4d = 4,
  partial_match = FALSE,
  ...
)

\method{basis}{gamm}(
  object,
  term = NULL,
  data = NULL,
  n = 100,
  n_2d = 50,
  n_3d = 16,
  n_4d = 4,
  partial_match = FALSE,
  ...
)

\method{basis}{list}(
  object,
  term = NULL,
  data = NULL,
  n = 100,
  n_2d = 50,
  n_3d = 16,
  n_4d = 4,
  partial_match = FALSE,
  ...
)

\method{basis}{default}(object, data, knots = NULL, constraints = FALSE, at = NULL, ...)
}
\arguments{
\item{object}{a smooth specification, the result of a call to one of
\code{\link[mgcv:s]{mgcv::s()}}., \code{\link[mgcv:te]{mgcv::te()}}, \code{\link[mgcv:te]{mgcv::ti()}}, or \code{\link[mgcv:t2]{mgcv::t2()}}, or a fitted
GAM(M) model.}

\item{...}{other arguments passed to \code{\link[mgcv:smoothCon]{mgcv::smoothCon()}}.}

\item{term}{character; select smooths in a fitted model}

\item{data}{a data frame containing the variables used in \code{smooth}.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{n_2d}{numeric; the number of new observations for each dimension of a
bivariate smooth. Not currently used; \code{n} is used for both dimensions.}

\item{n_3d}{numeric; the number of new observations to generate for the third
dimension of a 3D smooth.}

\item{n_4d}{numeric; the number of new observations to generate for the
dimensions higher than 2 (!) of a \emph{k}D smooth (\emph{k} >= 4). For example, if
the smooth is a 4D smooth, each of dimensions 3 and 4 will get \code{n_4d}
new observations.}

\item{partial_match}{logical; in the case of character \code{select}, should
\code{select} match partially against \code{smooths}? If \code{partial_match = TRUE},
\code{select} must only be a single string, a character vector of length 1.}

\item{knots}{a list or data frame with named components containing
knots locations. Names must match the covariates for which the basis
is required. See \code{\link[mgcv:smoothCon]{mgcv::smoothCon()}}.}

\item{constraints}{logical; should identifiability constraints be applied to
the smooth basis. See argument \code{absorb.cons} in \code{\link[mgcv:smoothCon]{mgcv::smoothCon()}}.}

\item{at}{a data frame containing values of the smooth covariate(s) at which
the basis should be evaluated.}
}
\value{
A tibble.
}
\description{
Creates a basis expansion from a definition of a smoother using the syntax
of \emph{mgcv}'s smooths via \code{\link[mgcv:s]{mgcv::s()}}., \code{\link[mgcv:te]{mgcv::te()}}, \code{\link[mgcv:te]{mgcv::ti()}}, and
\code{\link[mgcv:t2]{mgcv::t2()}}, or from a fitted GAM(M).
}
\examples{
load_mgcv()
\dontshow{
op <- options(pillar.sigfig = 3, cli.unicode = FALSE)
}
df <- data_sim("eg4", n = 400, seed = 42)

bf <- basis(s(x0), data = df)
bf <- basis(s(x2, by = fac, bs = "bs"), data = df, constraints = TRUE)
\dontshow{
options(op)
}
}
\author{
Gavin L. Simpson
}
