% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior-samples.R
\name{smooth_samples}
\alias{smooth_samples}
\alias{smooth_samples.gam}
\title{Posterior draws for individual smooths}
\usage{
smooth_samples(model, ...)

\method{smooth_samples}{gam}(
  model,
  term = NULL,
  n = 1,
  newdata = NULL,
  seed = NULL,
  freq = FALSE,
  unconditional = FALSE,
  ncores = 1L,
  n_vals = 200,
  ...
)
}
\arguments{
\item{model}{a fitted model of the supported types}

\item{...}{arguments passed to other methods. For \code{fitted_samples()}, these
are passed on to \code{predict.gam()}.}

\item{term}{character; select which smooth's posterior to draw from.
The default (\code{NULL}) means the posteriors of all smooths in \code{model}
wil be sampled from. If supplied, a character vector of requested terms.}

\item{n}{numeric; the number of posterior samples to return.}

\item{newdata}{data frame; new observations at which the posterior draws
from the model should be evaluated. If not supplied, the data used to fit
the model will be used for \code{newdata}, if available in \code{model}.}

\item{seed}{numeric; a random seed for the simulations.}

\item{freq}{logical; \code{TRUE} to use the frequentist covariance matrix of
the parameter estimators, \code{FALSE} to use the Bayesian posterior
covariance matrix of the parameters.}

\item{unconditional}{logical; if \code{TRUE} (and \code{freq == FALSE}) then the
Bayesian smoothing parameter uncertainty corrected covariance matrix is
used, if available.}

\item{ncores}{number of cores for generating random variables from a
multivariate normal distribution. Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}.
Parallelization will take place only if OpenMP is supported (but appears
to work on Windows with current \code{R}).}

\item{n_vals}{numeric; how many locations to evaluate the smooth at if
\code{newdata} not supplied}
}
\value{
A tibble with additional classes \code{"smooth_samples"} and
`"posterior_samples".

For the \code{"gam"} method, the columns currently returned (not in this order)
are:
\itemize{
\item \code{smooth}; character vector. Indicates the smooth function for that
particular draw,
\item \code{term}; character vector. Similar to \code{smooth}, but will contain the
full label for the smooth, to differentiate factor-by smooths for
example.
\item \code{by_variable}; character vector. If the smooth involves a \code{by} term, the
by variable will be named here, \code{NA_character_} otherwise.
\item \code{row}; integer. A vector of values \code{seq_len(n_vals)}, repeated if
\code{n > 1L}. Indexes the row in \code{newdata} for that particular draw.
\item \code{draw}; integer. A vector of integer values indexing the particular
posterior draw that each row belongs to.
\item \code{value}; numeric. The value of smooth function for this posterior draw
and covariate combination.
\item \code{.xN}; numeric. A series of one or more columns containing data required
for the smooth. \code{.x1} will always be present and contains the values of
the covariate in the smooth. For example if \code{smooth} is \code{s(z)} then
\code{.x1} will contain the values of covariate \code{z} at which the smooth was
evaluated. Further covariates for multi-dimensional thin plate splines
(e.g. \code{s(x, z)}) or tensor product smooths (e.g. \code{te(x,z,a)}) will
result in variables \code{.x1} and \code{.x2}, and \code{.x1}, \code{.x2}, and \code{.x3}
respectively, with the number (\code{1}, \code{2}, etc) representing the order
in which the covariates were specified in the smooth.
\item Additional columns will be present in the case of factor by smooths,
which will contain the level for the factor named in \code{by_variable} for
that particular posterior draw.
}
}
\description{
Returns draws from the posterior distributions of smooth functions in a GAM.
Useful, for example, for visualising the uncertainty in individual estimated
functions.
}
\section{Warning}{

The set of variables returned and their order in the tibble is subject to
change in future versions. Don't rely on position.
}

\examples{
load_mgcv()
\dontshow{op <- options(cli.unicode = FALSE)}
dat <- data_sim("eg1", n = 1000, seed = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

smooth_samples(m1, term = "s(x0)", n = 5, seed = 42)

## A factor by example (with a spurious covariate x0)
dat <- data_sim("eg4", n = 1000, seed = 2)

## fit model...
m2 <- gam(y ~ fac + s(x2, by = fac) + s(x0), data = dat)
sms <- smooth_samples(m2, n = 5, seed = 42)
draw(sms)
\dontshow{options(op)}
}
\author{
Gavin L. Simpson
}
