% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior-samples.R
\name{predicted_samples}
\alias{predicted_samples}
\alias{predicted_samples.gam}
\title{Draw new response values from the conditional distribution of the response}
\usage{
predicted_samples(model, ...)

\method{predicted_samples}{gam}(
  model,
  n = 1,
  newdata = NULL,
  seed = NULL,
  weights = NULL,
  ...
)
}
\arguments{
\item{model}{a fitted model of the supported types}

\item{...}{arguments passed to other methods. For \code{fitted_samples()}, these
are passed on to \code{predict.gam()}.}

\item{n}{numeric; the number of posterior samples to return.}

\item{newdata}{data frame; new observations at which the posterior draws
from the model should be evaluated. If not supplied, the data used to fit
the model will be used for \code{newdata}, if available in \code{model}.}

\item{seed}{numeric; a random seed for the simulations.}

\item{weights}{numeric; a vector of prior weights. If \code{newdata} is null
then defaults to \code{object[["prior.weights"]]}, otherwise a vector of ones.}
}
\value{
A tibble (data frame) with 3 columns containing the posterior
predicted values in long format. The columns are
\itemize{
\item \code{row} (integer) the row of \code{newdata} that each posterior draw relates to,
\item \code{draw} (integer) an index, in range \code{1:n}, indicating which draw each row
relates to,
\item \code{response} (numeric) the predicted response for the indicated row of
\code{newdata}.
}
}
\description{
Predicted values of the response (new response data) are drawn from the
fitted model, created via \code{simulate()} (e.g. \code{\link[=simulate.gam]{simulate.gam()}}) and returned
in a tidy, long, format. These predicted values do not include the
uncertainty in the estimated model; they are simply draws from the
conditional distribution of the response.
}
\examples{
load_mgcv()
\dontshow{
set.seed(2)
op <- options(cli.unicode = FALSE)
}
dat <- gamSim(1, n = 1000, dist = "normal", scale = 2)
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

predicted_samples(m, n = 5, seed = 42)

## Can pass arguments to predict.gam()
newd <- data.frame(x0 = runif(10), x1 = runif(10), x2 = runif(10),
                   x3 = runif(10))

## Exclude s(x2)
predicted_samples(m, n = 5, newd, exclude = "s(x2)", seed = 25)

## Exclude s(x1)
predicted_samples(m, n = 5, newd, exclude = "s(x1)", seed = 25)

## Select which terms --- result same as previous
predicted_samples(m, n = 5, newd, seed = 25,
                  terms = c("s(x0)", "s(x2)", "s(x3)"))
\dontshow{options(op)}
}
\author{
Gavin L. Simpson
}
