% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edf.R
\name{edf}
\alias{edf}
\alias{edf.gam}
\title{Effective degrees of freedom for smooth terms}
\usage{
edf(object, ...)

\method{edf}{gam}(object, smooth = NULL, alternative = FALSE, ...)
}
\arguments{
\item{object}{a fitted model from which to extract smooth-specific EDFs.}

\item{...}{arguments passed to methods.}

\item{smooth}{character; a vector of smooth terms whose EDFs will be
extracted. If \code{NULL}, the default, EDFs for all smooths will be returned.}

\item{alternative}{logical; return the alternative form for model EDFs of
Wood (2017; pp. 252).}
}
\description{
Extracts the effective degrees of freedom (EDF) for model smooth terms
}
\details{
Wood (2017; pp. 252) describes an alternative EDF describes an
alternative EDF form for the entire model
\deqn{\mathrm{EDF} = 2\mathrm{tr}(\mathbf{F}) -
  \mathrm{tr}(\mathbf{FF}),}{EDF = 2 * tr(F) - tr(F),} where
\eqn{\mathrm{tr}} is the matrix trace and \eqn{\mathbf{F}}{F} is a matrix
mapping un-penalized coefficient estimates to the penalized coefficient
estimates.  The trace of \eqn{\mathbf{F}}{F} is effectively the average
shrinkage of the coefficients multipled by the number of coefficients
(Wood, 2017). Smooth-specific EDFs then are obtained by summing up the
relevent elements of \eqn{\mathrm{diag}(2\mathbf{F} - \mathbf{FF})}.
}
\examples{
load_mgcv()
df <- data_sim("eg1", n = 400, seed = 42)
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")
edf(m)
edf(m, smooth = c("s(x0)", "s(x2)"))
}
