% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{term_variables}
\alias{term_variables}
\alias{term_variables.terms}
\alias{term_variables.gam}
\alias{term_variables.bam}
\title{Names of variables involved in a specified model term}
\usage{
term_variables(object, term, ...)

\method{term_variables}{terms}(object, term, ...)

\method{term_variables}{gam}(object, term, ...)

\method{term_variables}{bam}(object, term, ...)
}
\arguments{
\item{object}{an R object on which method dispatch is performed}

\item{term}{character; the name of a model term, in the sense of
\code{attr(terms(object), "term.labels")}. Currently not checked to see if the
term exists in the model.}

\item{...}{arguments passed to other methods.}
}
\value{
A character vector of variable names.
}
\description{
Given the name (a term label) of a term in a model, returns the names
of the variables involved in ther term.
}
