% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.R
\name{derivatives}
\alias{derivatives}
\alias{derivatives.default}
\alias{derivatives.gamm}
\alias{derivatives.gam}
\title{Derivatives of estimated smooths via finite differences}
\usage{
derivatives(object, ...)

\method{derivatives}{default}(object, ...)

\method{derivatives}{gamm}(object, ...)

\method{derivatives}{gam}(
  object,
  term,
  newdata,
  order = 1L,
  type = c("forward", "backward", "central"),
  n = 200,
  eps = 1e-07,
  interval = c("confidence", "simultaneous"),
  n_sim = 10000,
  level = 0.95,
  unconditional = FALSE,
  frequentist = FALSE,
  offset = NULL,
  ncores = 1,
  ...
)
}
\arguments{
\item{object}{an R object to compute derivatives for.}

\item{...}{arguments passed to other methods.}

\item{term}{character; vector of one or more smooth terms for which
derivatives are required. If missing, derivatives for all smooth terms
will be returned. Can be a partial match to a smooth term.}

\item{newdata}{a data frame containing the values of the model covariates
at which to evaluate the first derivatives of the smooths.}

\item{order}{numeric; the order of derivative.}

\item{type}{character; the type of finite difference used. One of
\code{"forward"}, \code{"backward"}, or \code{"central"}.}

\item{n}{numeric; the number of points to evaluate the derivative at.}

\item{eps}{numeric; the finite difference.}

\item{interval}{character; the type of interval to compute. One of
\code{"confidence"} for point-wise intervals, or \code{"simultaneous"} for
simultaneous intervals.}

\item{n_sim}{integer; the number of simulations used in computing the
simultaneous intervals.}

\item{level}{numeric; \verb{0 < level < 1}; the confidence level of the
point-wise or simultaneous interval. The default is \code{0.95} for a 95\%
interval.}

\item{unconditional}{logical; use smoothness selection-corrected Bayesian
covariance matrix?}

\item{frequentist}{logical; use the frequentist covariance matrix?}

\item{offset}{numeric; a value to use for any offset term}

\item{ncores}{number of cores for generating random variables from a
multivariate normal distribution. Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}.
Parallelization will take place only if OpenMP is supported (but appears
to work on Windows with current \code{R}).}
}
\value{
A tibble, currently with the following variables:
\itemize{
\item \code{smooth}: the smooth each row refers to,
\item \code{var}: the name of the variable involved in the smooth,
\item \code{data}: values of \code{var} at which the derivative was evaluated,
\item \code{derivative}: the estimated derivative,
\item \code{se}: the standard error of the estimated derivative,
\item \code{crit}: the critical value such that \code{derivative} ± \code{(crit * se)} gives
the upper and lower bounds of the requested confidence or simultaneous
interval (given \code{level}),
\item \code{lower}: the lower bound of the confidence or simultaneous interval,
\item \code{upper}: the upper bound of the confidence or simultaneous interval.
}
}
\description{
Derivatives of estimated smooths via finite differences
}
\examples{

load_mgcv()
\dontshow{
set.seed(42)
op <- options(cli.unicode = FALSE)
}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2, verbose = FALSE)
mod <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## first derivatives of all smooths using central finite differences
derivatives(mod, type = "central")
\dontshow{
options(op)
}
}
\author{
Gavin L. Simpson
}
