% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{residuals_hist_plot}
\alias{residuals_hist_plot}
\title{Histogram of model residuals}
\usage{
residuals_hist_plot(
  model,
  type = c("deviance", "pearson", "response"),
  n_bins = c("sturges", "scott", "fd"),
  ylab = NULL,
  xlab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL
)
}
\arguments{
\item{model}{a fitted model. Currently only class \code{"gam"}.}

\item{type}{character; type of residuals to use. Only \code{"deviance"},
\code{"response"}, and \code{"pearson"} residuals are allowed.}

\item{n_bins}{character or numeric; either the number of bins or a string
indicating how to calculate the number of bins.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{xlab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}
}
\description{
Histogram of model residuals
}
