% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-methods.R
\name{draw.evaluated_smooth}
\alias{draw.evaluated_smooth}
\alias{draw.evaluated_1d_smooth}
\alias{draw.evaluated_2d_smooth}
\alias{geom_rug}
\alias{draw.evaluated_re_smooth}
\alias{draw.evaluated_fs_smooth}
\alias{draw.evaluated_parametric_term}
\title{Plot estimated smooths}
\usage{
\method{draw}{evaluated_1d_smooth}(object, rug = NULL, xlab, ylab,
  title = NULL, subtitle = NULL, caption = NULL, ...)

\method{draw}{evaluated_2d_smooth}(object, show = c("estimate", "se"),
  contour = TRUE, xlab, ylab, title = NULL, subtitle = NULL,
  caption = NULL, ...)

\method{draw}{evaluated_re_smooth}(object, qq_line = TRUE, xlab, ylab,
  title = NULL, subtitle = NULL, caption = NULL, ...)

\method{draw}{evaluated_fs_smooth}(object, rug = NULL, xlab, ylab,
  title = NULL, subtitle = NULL, caption = NULL,
  colour_scale = scale_colour_discrete, ...)

\method{draw}{evaluated_parametric_term}(object, xlab, ylab,
  title = NULL, subtitle = NULL, caption = NULL, rug = TRUE,
  position = "identity", ...)
}
\arguments{
\item{object}{an object, the result of a call to \code{\link[=evaluate_smooth]{evaluate_smooth()}}.}

\item{rug}{For \code{evaluate_smooth()}, a numeric vector of values for the
location of data on the x axis. The default of \code{NULL} results in no
rug plot being drawn. For \code{evaluate_parametric_terms()}, a logical to
indicate if a rug plot should be drawn.}

\item{xlab}{character or expression; the label for the x axis. If not
supplied, a suitable label will be generated from \code{object}.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated from \code{object}.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{...}{arguments passed to other methods.}

\item{show}{character; plot the estimated smooth (\code{"estimate"}) or its
standard error (\code{"se"}).}

\item{contour}{logical; should contours be draw on the plot using
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{qq_line}{logical; draw a reference line through the lower and upper
theoretical quartiles.}

\item{colour_scale}{function; an appropriate discrete colour scale from \code{ggplot2}.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plots estimated univariate and bivariate smooths using ggplot2.
}
\examples{
suppressPackageStartupMessages(library("mgcv"))

\dontshow{set.seed(2)}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

sm <- evaluate_smooth(m1, "s(x2)")
draw(sm)

\dontshow{set.seed(2)}
dat <- gamSim(2, n = 1000, dist = "normal", scale = 1)
m2 <- gam(y ~ s(x, z, k = 40), data = dat$data, method = "REML")

sm <- evaluate_smooth(m2, "s(x,z)", n = 100)
draw(sm)
}
\author{
Gavin L. Simpson
}
