% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-methods.R
\name{add_fitted_samples}
\alias{add_fitted_samples}
\alias{add_predicted_samples}
\alias{add_posterior_samples}
\alias{add_smooth_samples}
\title{Add posterior draws from a model to a data object}
\usage{
add_fitted_samples(object, model, n = 1, seed = NULL, ...)

add_predicted_samples(object, model, n = 1, seed = NULL, ...)

add_posterior_samples(object, model, n = 1, seed = NULL, ...)

add_smooth_samples(object, model, n = 1, seed = NULL, select = NULL, ...)
}
\arguments{
\item{object}{a data frame or tibble to which the posterior draws will be
added.}

\item{model}{a fitted GAM (or GAM-like) object for which a posterior draw
method exists.}

\item{n}{integer; the number of posterior draws to add.}

\item{seed}{numeric; a value to seed the random number generator.}

\item{...}{arguments are passed to the posterior draw function, currently one
of \code{\link[=fitted_samples]{fitted_samples()}}, \code{\link[=predicted_samples]{predicted_samples()}}, or \code{\link[=posterior_samples]{posterior_samples()}}. \code{n}
and \code{seed} are already specified here as arguments and are also passed on
to the posterior sampling function.}

\item{select}{character; select which smooth's posterior to draw from. The
default, \code{NULL}, means the posteriors of all smooths in model wil be
sampled from individually. If supplied, a character vector of requested
smooth terms.}
}
\description{
Adds draws from the posterior distribution of \code{model} to the data \code{object}
using one of \code{\link[=fitted_samples]{fitted_samples()}}, \code{\link[=predicted_samples]{predicted_samples()}}, or
\code{\link[=posterior_samples]{posterior_samples()}}.
}
\examples{
\dontshow{
op <- options(pillar.sigfig = 3)
}
load_mgcv()

df <- data_sim("eg1", n = 400, seed = 42)

m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

# add fitted samples (posterior draws of the expected value of the response)
# note that there are 800 rows in the output: 400 data by `n = 2` samples.
df |>
  add_fitted_samples(m, n = 2, seed = 84)

# add posterior draws from smooth s(x2)
df |>
  add_smooth_samples(m, n = 2, seed = 2, select= "s(x2)")
\dontshow{
  options(op)
}
}
