% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearweek-scale.R
\name{scale_x_grates_yearweek}
\alias{scale_x_grates_yearweek}
\alias{scale_x_grates_yearweek_monday}
\alias{scale_x_grates_yearweek_isoweek}
\alias{scale_x_grates_yearweek_tuesday}
\alias{scale_x_grates_yearweek_wednesday}
\alias{scale_x_grates_yearweek_thursday}
\alias{scale_x_grates_yearweek_friday}
\alias{scale_x_grates_yearweek_saturday}
\alias{scale_x_grates_yearweek_sunday}
\alias{scale_x_grates_yearweek_epiweek}
\title{Yearweek scale}
\usage{
scale_x_grates_yearweek(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6L,
  firstday,
  format = NULL
)

scale_x_grates_yearweek_monday(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)

scale_x_grates_yearweek_isoweek(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)

scale_x_grates_yearweek_tuesday(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)

scale_x_grates_yearweek_wednesday(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)

scale_x_grates_yearweek_thursday(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)

scale_x_grates_yearweek_friday(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)

scale_x_grates_yearweek_saturday(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)

scale_x_grates_yearweek_sunday(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)

scale_x_grates_yearweek_epiweek(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6,
  format = NULL
)
}
\arguments{
\item{...}{Not currently used.}

\item{breaks}{A \verb{<grates_yearweek>} vector of the desired breaks.}

\item{n.breaks}{\verb{[integer]}

Approximate number of breaks calculated using \code{scales::breaks_pretty}
(default 6L).

Will only have an effect if \code{breaks = waiver()}.}

\item{firstday}{\verb{[integer]}

Integer value of the first weekday: 1 (Monday) to 7 (Sunday).}

\item{format}{Format to use if "Date" or year/week scales are required.

If NULL (default) then labels are in the standard yearweek format (YYYY-Wxx).

If "week" then the labels are of the form Www (e.g. W37).

If "year" then labels are of the form YYYY (e.g. 2020).

Otherwise the value is used by \code{format.Date()} and can be any input
acceptable by that function.

Note that when date scales are requested the grate labels are first coerced
via \code{as.Date()}.}
}
\value{
A scale for use with ggplot2.
}
\description{
ggplot2 scale for an \verb{<grates_yearweek>} vector.
}
\examples{
\dontshow{if (requireNamespace("outbreaks") && requireNamespace("ggplot2")) withAutoprint(\{ # examplesIf}

# use simulated linelist data from the outbreaks package
linelist <- outbreaks::ebola_sim_clean$linelist
x <- as_yearweek(linelist$date_of_infection, firstday = 4)
dat <- aggregate(list(cases = x), by = list(week = x), FUN = length)

# plot the output
(week_plot <-
    ggplot2::ggplot(dat, ggplot2::aes(week, cases)) +
    ggplot2::geom_col(width = 1, colour = "white") +
    ggplot2::theme_bw())

# We can have non-centred date labels on the x_axis by using the
# associated scale function and explicitly specifying a format for the
# date labels and a value for firstday:
week_plot + scale_x_grates_yearweek(format = "\%Y-\%m-\%d", firstday = 4)
\dontshow{\}) # examplesIf}
}
