% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_period.R
\name{as_period}
\alias{as_period}
\alias{as_period.default}
\alias{as_period.period}
\alias{as_period.Date}
\alias{as_period.POSIXt}
\alias{as_period.character}
\alias{as_period.factor}
\title{Convert an object to a period}
\usage{
as_period(x, interval, firstdate, ...)

\method{as_period}{default}(x, interval, firstdate, ...)

\method{as_period}{period}(x, interval = 1L, firstdate = NULL, ...)

\method{as_period}{Date}(x, interval = 1L, firstdate = NULL, ...)

\method{as_period}{POSIXt}(x, interval = 1L, firstdate = NULL, ...)

\method{as_period}{character}(x, interval = 1L, firstdate = NULL, ...)

\method{as_period}{factor}(x, interval = 1L, firstdate = NULL, ...)
}
\arguments{
\item{x}{An object to coerce to a period.}

\item{interval}{An integer or character indicating the (fixed) size of the
time interval used for computing the incidence; defaults to 1 day.
More details can be found in the "Interval specification" below.}

\item{firstdate}{The date to anchor the intervals from.  If NULL (default)
the earliest date in the vector will be used.}

\item{...}{Not currently used.}
}
\value{
A \code{period} object except when interval values 1, 1L, "day" or "days"
(both without prefix) are used.  In this situation the
returned object is of the standard "Date" class.

\subsection{Interval specification}{
\code{interval} can be specified as either an integer value or a more
standard specification such as "day", "week", "month", "quarter" or "year".
The format in this situation is similar to that used by \code{\link[=seq.Date]{seq.Date()}}
where these values can optionally be preceded by a (positive or negative)
integer and a space, or followed by "s"\preformatted{* (x) day(s)
* (x) weeks(s)
* (x) epiweeks(s)
* (x) isoweeks(s)
* (x) months(s)
* (x) quarter(s)
* (x) years(s)
}

Note that for the values "month", "quarter" and "year", intervals are
always made to start at the beginning of the calendar equivalent.
If the input is an integer value the input is treated as if it was
specified in days (i.e. 2 and 2 days) produce the same output.

The only interval values that do not produce these grouped classes are 1,
1L, "day" or "days" (both without prefix) are used.  In this situation the
returned object is of the standard "Date" class.
}
}
\description{
Convert an object to a period
}
\note{
Internally \code{period} objects are represented by the date at the beginning
of the period and then stored as the number of days (starting at 0) since
the Unix Epoch (1970-01-01).
}
\examples{
as_period(Sys.Date(), interval = "28 days")
as_period(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"), interval = 10)
as_period("2019-05-03", interval = "2 weeks")

}
