% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basecor_utils.R
\name{basecor-utils}
\alias{basecor-utils}
\alias{cholcor}
\alias{Hcorrel}
\title{Internal functions used by basecor}
\usage{
cholcor(theta, p, itheta, parametrization = "cpc")

Hcorrel(theta, p, parametrization, itheta, C0, decomposition, ...)
}
\arguments{
\item{theta}{numeric parameter vector.}

\item{p}{integer with the dimension,
the number of rows/columns of the correlation matrix.}

\item{itheta}{integer vector to specify the (vectorized) position
where 'theta' will be placed in the (initial, before fill-in)
Cholesky (lower triangle) factor. Default is missing and assumes
the dense case for when \code{itheta = which(lower.tri(...))}.}

\item{parametrization}{character to specify the
parametrization used. The available ones are
"cpc" (or "CPC") or "sap" (or "SAP").
See Details. The default is "cpc".}

\item{C0}{base correlation matrix.}

\item{decomposition}{character to inform
which decomposition is to be applied to the
hessian. The options are "eigen", "svd" and "chol".}

\item{...}{further arguments passed on.}
}
\value{
matrix with lower triangle as the Cholesky factor
of a correlation matrix if parametrization is
"cpc" or "sap" and of a precision matrix
(of a correlation matrix) if parametrization is
'itp' (with 'd0' as the diagonal elements).

list containing the hessian,
its 'square root', inverse 'square root' along
with the decomposition used
}
\description{
Internal functions used by basecor
}
\section{Functions}{
\itemize{
\item \code{cholcor()}: Cholesky parametrization for a correlation matrix

\item \code{Hcorrel()}: Evaluate the hessian of the KLD for a
correlation model around a base model.

}}
