% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_pc_correl.R
\name{cgeneric_pc_correl}
\alias{cgeneric_pc_correl}
\title{Build an \code{inla.cgeneric} to implement the PC prior,
proposed on Simpson et. al. (2007),
for the correlation matrix parametrized from the
hypershere decomposition, see details.}
\usage{
cgeneric_pc_correl(
  n,
  lambda,
  debug = FALSE,
  useINLAprecomp = TRUE,
  libpath = NULL
)
}
\arguments{
\item{n}{integer to define the size of the matrix}

\item{lambda}{numeric (positive), the penalization rate parameter}

\item{debug}{integer, default is zero, indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.
This is not considered if 'libpath' is provided.}

\item{libpath}{string, default is NULL, with the path to the shared object.}
}
\value{
a \code{inla.cgeneric}, \code{\link[=cgeneric]{cgeneric()}} object.
}
\description{
Build an \code{inla.cgeneric} to implement the PC prior,
proposed on Simpson et. al. (2007),
for the correlation matrix parametrized from the
hypershere decomposition, see details.
}
\details{
The hypershere decomposition, as proposed in
Rapisarda, Brigo and Mercurio (2007)
consider \eqn{\theta[k] \in [0, \infty], k=1,...,m=n(n-1)/2}
compute \eqn{x[k] = pi/(1+exp(-\theta[k]))}
organize it as a lower triangle of a \eqn{n \times n} matrix
\deqn{B[i,j] = \left\{\begin{array}{cc}
cos(x[i,j]) & j=1 \\
cos(x[i,j])prod_{k=1}^{j-1}sin(x[i,k]) &  2 <= j <= i-1 \\
prod_{k=1}^{j-1}sin(x[i,k])  & j=i \\
0 &  j+1 <= j <= n \end{array}\right.}
Result
\deqn{\gamma[i,j] = -log(sin(x[i,j]))}
\deqn{KLD(R) = \sqrt(2\sum_{i=2}^n\sum_{j=1}^{i-1} \gamma[i,j]}
}
\references{
Daniel Simpson, H\\aa vard Rue, Andrea Riebler, Thiago G.
Martins and Sigrunn H. S\\o rbye (2017).
Penalising Model Component Complexity:
A Principled, Practical Approach to Constructing Priors
Statistical Science 2017, Vol. 32, No. 1, 1–28.
<doi 10.1214/16-STS576>

Rapisarda, Brigo and Mercurio (2007).
Parameterizing correlations: a geometric interpretation.
IMA Journal of Management Mathematics (2007) 18, 55-73.
<doi 10.1093/imaman/dpl010>
}
