% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEdges.R
\name{getEdges}
\alias{getEdges}
\title{Build list of edges from tweets}
\usage{
getEdges(data, tweets, source, str.length = NULL, ...)
}
\arguments{
\item{data}{\code{data.frame} of tweets, typically returned by 
\code{\link[twitteR]{searchTwitter}}, required.}

\item{tweets}{Column name of tweets within \code{data}, must be a 
\code{character} string, required.}

\item{source}{User names or ID column of \code{tweets} author, must be a 
\code{character} string, required.}

\item{str.length}{Defaults to \code{NULL}. Shorten length of @tags 
(see details), to a maximum number of characters.}

\item{...}{Any other columns to be passed on to the edges.}
}
\description{
Builds a table of edges (source, target) from a data.frame 
of tweets by subsetting @tags from the text.
}
\details{
The edges function takes in a data frame of tweets, typically 
obtained from the twitter Search or Streaming API, scrapes the content of 
tweets to subset the @tags subsequently forming a table of edges. @tags 
are subsets of regular expressions between at-signs (@) and first 
space (" "). 
Note that the table of edges returned is meant for a directed graph.
Node labels can be shortened using the \code{str.length} parameters. 
This is useful for non-latin alphabet where nodes may be wrongly identified 
(i.e.: Chinese Sina Weibo data).
}
\examples{
\dontrun{
# simulate dataset
tweets <- data.frame(text = c("I tweet @you about @him", 
                              "I tweet @me about @you"),
                     screenName = c("me", "him"),
                     stringsAsFactors = FALSE)

# get edges
edges <- getEdges(data = tweets, tweets = "text", source = "screenName")

# use igraph to make graph object
g <- igraph::graph.data.frame(edges)
plot(g)
}

}
\author{
John Coene \email{john.coene@gmail.com}
}
