% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{gini_coeff}
\alias{gini_coeff}
\title{Compute Gini coefficient from a numeric vector}
\usage{
gini_coeff(x, unbiased = TRUE)
}
\arguments{
\item{x}{A numeric vector with positive values}

\item{unbiased}{A logical value indicating whether the computed coefficient
is biased or not. Unbiased value are equal to n/(n-1) times the biased ones.}
}
\value{
A numeric value corresponding to the Gini coefficient of the numeric
vector
}
\description{
The function computes Gini coefficient from a numeric vector
}
\examples{
x <- c(10, 2, 5, 15)
gini <- gini_coeff(x)
}
\author{
P. Savary
}
\keyword{internal}
