% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_rare_gen_index.R
\name{pop_rare_gen_index}
\alias{pop_rare_gen_index}
\title{Compute population-level rarefied genetic indices with ADZE software}
\usage{
pop_rare_gen_index(x, max_g = NULL, pop_names = NULL)
}
\arguments{
\item{x}{An object of class \code{genind}
from package \pkg{adegenet}.}

\item{max_g}{(optional default = NULL) The maximum standardized sample size
used by ADZE software (MAX_G) in ADZE manual. It is equal to twice the
minimum number of individuals considered for the rarefaction analysis. By
default, it is equal to twice the number of individuals in the smallest
population. Ohterwise, it must be either a numeric or integer value.}

\item{pop_names}{(optional) A character vector indicating population names.
It is of the same length as the number of populations. Without this
argument, populations are given the names they have initially in the
'genind' object (which is sometimes only a number). The order of the
population names must match with their order in the 'genind' object.
The function does not reorder them. Users must be careful.}
}
\value{
An object of class \code{data.frame} whose rows
correspond to populations and columns to population attributes
(ID, size, genetic indices). By default, the first column corresponds to
the population names (ID). The order of the columns depends on the
vector 'indices'.
}
\description{
The function computes population-level rarefied genetic indices 
from an object of class \code{genind} with the ADZE software.
}
\author{
P. Savary
}
\keyword{internal}
