% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_to_shp.R
\name{graph_to_shp}
\alias{graph_to_shp}
\title{Export a spatial graph to shapefile layers}
\usage{
graph_to_shp(graph, crds, mode = "both", crds_crs, layer_name, dir_path,
  metrics = FALSE)
}
\arguments{
\item{graph}{A graph object of class \code{igraph}}

\item{crds}{(if 'mode = 'spatial'') A \code{data.frame} with the spatial
coordinates of the graph's nodes. It must have three columns:
\itemize{
\item{ID: Name of the graph's nodes (will be converted into character string).
The names must the same as the nodes' names of the graph object of
class \code{igraph} (\code{igraph::V(graph)$name})}
\item{x: Longitude (numeric) of the graphs' nodes in the coordinates
reference system indicated with the argument crds_crs.}
\item{y: Latitude (numeric) of the graphs' nodes in the coordinates
reference system indicated with the argument crds_crs.}
}}

\item{mode}{Indicates which shapefile layers will be created
\itemize{
\item{If 'mode = 'both'' (default), then two shapefile layers are created,
one for the nodes and another for the links.}
\item{If 'mode = 'node'', a shapefile layer is created for the nodes only.}
\item{If 'mode = 'link'', a shapefile layer is created for the links only.}
}}

\item{crds_crs}{A character string indicating the Coordinates Reference System
of the spatial coordinates of the nodes and of the shapefile layers created.
The projection and datum are given in the PROJ.4 format.}

\item{layer_name}{A character string indicating the suffix of the name of
the layers to be created.}

\item{dir_path}{A character string corresponding to the path to the directory
in which the shapefile layers will be exported. If \code{dir_path = "wd"},
then the layers are created in the current working directory.}

\item{metrics}{(not possible if 'mode = 'link'') Logical. Should metrics
be calculated and integrated in the attribute table of the nodes' shapefile
layer? (default: FALSE)
Metrics calculated are degrees, betweenness centrality and sum of
inverse weight (if links are weighted)}
}
\value{
Create shapefile layers in the directory specified with the parameter
'dir_path'.
}
\description{
The function enables to export a spatial graph to shapefile layers.
}
\examples{
data(data_tuto)
mat_w <- data_tuto[[1]]
gp <- gen_graph_topo(mat_w = mat_w, topo = "gabriel")
crds_crs1 <- "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 "
crds_crs2 <- "+x_0=700000 +y_0=6600000 +ellps=GRS80 +units=m +no_defs"
crds_crs <- paste(crds_crs1, crds_crs2, sep = "")
crds <- pts_pop_simul
layer_name <- "graph_dps_gab"
graph_to_shp(graph = gp, crds = pts_pop_simul, mode = "both",
             crds_crs = crds_crs,
             layer_name = "test_fonct",
             dir_path = tempdir(),
             metrics = TRUE)
}
\author{
P. Savary
}
