% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{Analyses}
\alias{Analyses}
\alias{AddAnalysis}
\alias{DropAnalysis}
\title{Analysis table functions}
\usage{
Analyses(data, description = FALSE)

AddAnalysis(
  data,
  name,
  table,
  by = NULL,
  warn.present = TRUE,
  warn.genes = TRUE
)

DropAnalysis(data, pattern = NULL)
}
\arguments{
\item{data}{A grandR object}

\item{description}{if TRUE, also return the column names of each analysis table (i.e. a list named according to the analyses)}

\item{name}{The user-defined analysis name}

\item{table}{The analysis table to add}

\item{by}{Specify a column that contains gene names or symbols (see details)}

\item{warn.present}{Warn if an analysis with the same name is already present (and then overwrite)}

\item{warn.genes}{Warn if genes are missing (and then add NA)}

\item{pattern}{A regular expression that is matched to analysis names}
}
\value{
Either the analysis names or a grandR data with added/removed slots or the metatable to be used with AddAnalysis
}
\description{
Get analysis names and add or remove analyses
}
\details{
The columns in the analysis tables are defined by the analysis method (e.g. "Synthesis","Half-life" and "rmse" by \code{FitKinetics}).
A call to an analysis function might produce more than one table (e.g. because kinetic modeling is done for multiple \link{Condition}s). In this case,
AddAnalysisTable produces more than one analysis table.

\code{AddAnalysis} is in most cases  not called directly by the user, but is
used by analysis methods to add their final result to a grandR object (e.g., \link{FitKinetics},\link{LikelihoodRatioTest},\link{LFC},\link{PairwiseDESeq2}).

If it is called by the user (e.g. to add analysis results from external tools or from the literature, see pulse-chase vignette), then
the user must make sure that either the rownames of the given table can be recognized as genes (names or symbols), or that there is a column in the
table giving genes (this must be specified as the "by" parameter). The table does neither have to be sorted the same way the grandR object is, nor does
it have to be complete. \code{AddAnalysis} will take care or reordering and inserting NA for missing genes (and it will issue a warning in case of missing genes).
}
\section{Functions}{
\itemize{
\item \code{Analyses()}: Obtain the analyses names

\item \code{AddAnalysis()}: Add an analysis table

\item \code{DropAnalysis()}: Remove analyses from the grandR object

}}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))

sars <- Normalize(sars)     # default behavior is to update the default slot; this calls AddSlot
Slots(sars)
DefaultSlot(sars)
sars <- DropSlot(sars,"norm")
sars                        # note that the default slot reverted to count

}
\seealso{
\link{Slots}, \link{DefaultSlot}
}
\concept{grandr}
