% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{FormatCorrelation}
\alias{FormatCorrelation}
\title{Formatting function for correlations}
\usage{
FormatCorrelation(
  method = "pearson",
  n.format = NULL,
  coeff.format = "\%.2f",
  p.format = "\%.2g"
)
}
\arguments{
\item{method}{how to compute correlation coefficients (can be pearson, spearman or kendall)}

\item{n.format}{format string for the number of data points (see \link{sprintf}); can be NULL (don't output the number of data points)}

\item{coeff.format}{format string for the correlation coefficient (see \link{sprintf}); can be NULL (don't output the correlation coefficient)}

\item{p.format}{format string for the P value (see \link{sprintf}); can be NULL (don't output the P value)}
}
\value{
a function
}
\description{
Returns a function that takes x and y and returns a formatted output to describe the correlation of x and y
}
\details{
Use this for the \code{correlation} parameter of \link{PlotScatter}
}
\examples{

set.seed(42)
data <- data.frame(u=runif(500))  # generate some correlated data
data$x <- rnorm(500,mean=data$u)
data$y <- rnorm(500,mean=data$u)

fun <- FormatCorrelation()
fun(data$x,data$y)

fun <- FormatCorrelation(method="spearman",p.format="\%.4g")
fun(data$x,data$y)

}
\concept{globalplot}
