\name{GrammaticalExhaustiveSearch}

\alias{GrammaticalExhaustiveSearch}
\alias{print.GESearch}

\title{Exhaustive Search}
\description{ %%  ~~ A concise (1-5 lines) description of what the function does. ~~
Exhaustive Search within context-free grammar.
}
\usage{

GrammaticalExhaustiveSearch(grammar, evalFunc,
                max.depth = GrammarGetDepth(grammar),
                startSymb = GrammarStartSymbol(grammar),
                max.len = GrammarMaxSequenceLen(grammar, max.depth, startSymb),
                wrappings = 3,
                terminationCost = NA,
                monitorFunc = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{grammar}{
    A \code{\link[=CreateGrammar]{grammar}} object.
  }
 \item{evalFunc}{
    The evaluation function, taking an expression as its input
    and returning the cost (i.e., the score) of the expression.
 }
\item{max.depth}{
    Maximum depth of recursion, in case of a cyclic grammar. 
    By default it is limited to the number of production rules in the grammar.
}
\item{startSymb}{
    The symbol where the generation of a new expression should start.
}
\item{max.len}{
    Maximum length of the sequences to search. 
    By default it is determined by \code{max.depth}.
}
\item{wrappings}{
    The number of times the function is allowed to wrap around \code{inputString}
    if non-terminal symbols are still remaining.
}
\item{terminationCost}{
    Target cost. If an expression with this cost or less is found,
   the algorithm terminates.
}
 \item{monitorFunc}{
  A function that is called at each iteration. It can be used to monitor the search.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
  \code{GrammaticalExhaustiveSearch} performs an exhaustive search,
  iterating through all possible expressions that can be generated by the \code{grammar},
  to find the expression that minimises \code{evalFunc}.

  The search terminates when all possible expressions are exhausted,
  or when an expression with a cost less than \code{terminationCost} is discovered.

  If a \code{monitorFunc} is given, it is called for each expression, and it receives a 
  list similar to the \code{GrammaticalExhaustiveSearch}'s return value with the information
  availabe for that expression.
}

\value{
  \item{bestExpression}{The Best expresssion.}
  \item{bestSequence}{Best expresssion's generating sequence.}
  \item{bestCost}{Best expresssion's cost.}
  \item{numExpr}{Number of evaluated expressions.}
  
  In addition, the \code{monitorFunc} receives the following additional slots: 
  \item{currentExpression}{The current expresssion.}
  \item{currentSequence}{Current expresssion's generating sequence.}
  \item{currentCost}{Current expresssion's cost.}
}

%\references{
%% ~put references to the literature/web site here ~
%}
%\author{
%%  ~~who you are~~
%}
%\note{
%%  ~~further notes~~
%}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{GrammarGetNextSequence}},
\code{\link{GrammaticalEvolution}}
}
\examples{
library("gramEvol")

ruleDef <- list(expr = gsrule("<var><op><var>"),
                op   = gsrule("+", "-", "*"),
                var  = gsrule("A", "B"))

# Create a grammar object
grammarDef <- CreateGrammar(ruleDef)         


# use exhaustive search to find the sequence for creating "B - A"
evalFunc <- function(expr) {
  if (as.character(expr) == "B - A") {
    return(0) # Minimum error
  } else {
    return(1) # maximum error
  }
}

res <- GrammaticalExhaustiveSearch(grammarDef, evalFunc, terminationCost = 0)

print(res)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
