% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.Methods.R
\name{SARAH}
\alias{SARAH}
\title{Stochastic Recursive Gradient Algorithm (SARAH) Method Learning Function}
\usage{
SARAH(dataTrain, alpha = 0.1, maxIter = 10, innerIter = 10, seed = NULL)
}
\arguments{
\item{dataTrain}{a data.frame that representing training data (\eqn{m \times n}),
where \eqn{m} is the number of instances and \eqn{n} is the number
of variables where the last column is the output variable. dataTrain
must have at least two columns and ten rows of data that contain
only numbers (integer or float).}

\item{alpha}{a float value representing learning rate. Default value is 0.1}

\item{maxIter}{the maximal number of iterations in outerloop.}

\item{innerIter}{the maximal number of iterations in innerloop.}

\item{seed}{a integer value for static random. Default value is NULL, which means
the function will not do static random.}
}
\value{
a vector matrix of theta (coefficient) for linear model.
}
\description{
A function to build prediction model using SARAH method.
}
\details{
This function Similarly to \code{\link{SVRG}}, \code{\link{SARAH}} iterations are divided
into the outer loop where a full gradient is computed and the inner loop where only
stochastic gradient is computed. Unlike the case of \code{\link{SVRG}}, the steps of
the inner loop of \code{\link{SARAH}} are based on accumulated stochastic information.
}
\examples{
##################################
## Learning and Build Model with SARAH
## load R Package data
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## split dataset
splitedDataSet <- splitData(dataSet)
## build model with SARAH
SARAHmodel <- SARAH(splitedDataSet$dataTrain)
#show result
print(SARAHmodel)

}
\references{
Lam M. Nguyen, Jie Lu, Katya Scheinberg, Martin Takac
SARAH: A Novel Method for Machine Learning Problems Using Stochastic Recursive Gradient,
arXiv preprint arXiv:1703.00102,
(2017)
}
\seealso{
\code{\link{SVRG}}, \code{\link{SSGD}}, \code{\link{SARAHPlus}}
}
