% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.Methods.R
\name{SGD}
\alias{SGD}
\title{Stochastic Gradient Descent (SGD) Method Learning Function}
\usage{
SGD(dataTrain, alpha = 0.1, maxIter = 10, seed = NULL)
}
\arguments{
\item{dataTrain}{a data.frame that representing training data (\eqn{m \times n}), 
where \eqn{m} is the number of instances and \eqn{n} is the number 
of variables where the last column is the output variable. dataTrain 
must have at least two columns and ten rows of data that contain 
only numbers (integer or float).}

\item{alpha}{a float value representing learning rate. Default value is 0.1}

\item{maxIter}{the maximal number of iterations.}

\item{seed}{a integer value for static random. Default value is NULL, which means 
the function will not do static random.}
}
\value{
a vector matrix of theta (coefficient) for linear model.
}
\description{
A function to build prediction model using Stochastic Gradient Descent (SGD) method.
}
\details{
This function based on \code{\link{GD}} method with optimization to use only one instance
of training data stochasticaly. So, SGD will perform fast computation and the learning.  
However, the learning to reach minimum cost will become more unstable.
}
\examples{
 
################################## 
## Learning and Build Model with SGD
## load R Package data  
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## split dataset
splitedDataSet <- splitData(dataSet)
## build model with SGD
SGDmodel <- SGD(splitedDataSet$dataTrain) 
#show result
print(SGDmodel)

}
\references{
N. Le Roux, M. Schmidt, F. Bach
A Stochastic Gradient Method with an Exceptional Convergence Rate for Finite Training Sets, 
Advances in Neural Information Processing Systems, 
(2011)
}
\seealso{
\code{\link{SAGD}}
}
