% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.Methods.R
\name{ADAM}
\alias{ADAM}
\title{ADADELTA Method Learning Function}
\usage{
ADAM(dataTrain, alpha = 0.1, maxIter = 10, seed = NULL)
}
\arguments{
\item{dataTrain}{a data.frame that representing training data (\eqn{m \times n}), 
where \eqn{m} is the number of instances and \eqn{n} is the number 
of variables where the last column is the output variable. dataTrain 
must have at least two columns and ten rows of data that contain 
only numbers (integer or float).}

\item{alpha}{a float value representing learning rate. Default value is 0.1}

\item{maxIter}{the maximal number of iterations.}

\item{seed}{a integer value for static random. Default value is NULL, which means 
the function will not do static random.}
}
\value{
a vector matrix of theta (coefficient) for linear model.
}
\description{
A function to build prediction model using ADAM method.
}
\details{
This function based on \code{\link{SGD}} with an optimization to create
an adaptive learning rate by two moment estimation called mean and variance.
}
\examples{
 
################################## 
## Learning and Build Model with ADAM
## load R Package data  
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## split dataset
splitedDataSet <- splitData(dataSet)
## build model with ADAM
ADAMmodel <- ADAM(splitedDataSet$dataTrain) 
#show result
print(ADAM)

}
\references{
D.P Kingma, J. Lei
Adam: a Method for Stochastic Optimization, 
International Conference on Learning Representation, 
pp. 1-13 (2015)
}
\seealso{
\code{\link{ADAGRAD}}, \code{\link{RMSPROP}}, \code{\link{ADADELTA}}
}
