% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp.R
\name{gp_init}
\alias{gp_init}
\title{Initialize a GP model}
\usage{
gp_init(
  cfs = cf_sexp(),
  lik = lik_gaussian(),
  method = method_full(),
  approx = approx_laplace()
)
}
\arguments{
\item{cfs}{The covariance function(s). Either a single covariance function 
or a list of them. See \code{\link{cf}}.}

\item{lik}{Likelihood (observation model). See \code{\link{lik}}.}

\item{method}{Method for approximating the covariance function.
See \code{\link{method}}.}

\item{approx}{Approximate inference method for Gaussian approximation
for the posterior of the latent values. See \code{\link{approx}}.}
}
\value{
A GP model object that can be passed to other functions, for example 
when optimizing the hyperparameters or making predictions.
}
\description{
Initializes a GP model with given covariance function(s) and likelihood. 
The model can then be fitted using \code{\link{gp_fit}}. For hyperparameter 
optimization, see \code{\link{gp_optim}}
}
\section{References}{


Rasmussen, C. E. and Williams, C. K. I. (2006). Gaussian processes for machine learning.
MIT Press.
}

\examples{

# Full exact GP with Gaussian likelihood
gp <- gp_init(
  cfs = cf_sexp(),
  lik = lik_gaussian(),
  method = method_full()
)

# Binary classification model with EP approximation for the latent values
# and FITC sparse approximation to facilitate large datasets
gp <- gp_init(
  cfs = cf_sexp(),
  lik = lik_bernoulli(),
  approx = approx_ep(),
  method = method_fitc(num_inducing = 100)
)


}
