% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.R
\name{goose_map}
\alias{goose_map}
\title{Map Async Function Over Data}
\usage{
goose_map(data, query_template, max_workers = 4)
}
\arguments{
\item{data}{Vector or list of data elements}

\item{query_template}{Query template with \{x\} placeholder}

\item{max_workers}{Maximum parallel workers}
}
\value{
List of AI responses
}
\description{
Apply an AI query to each element of a dataset
}
\examples{
\dontrun{
# Analyze multiple code snippets
code_snippets <- c("function(x) x^2", "for(i in 1:10) print(i)")
reviews <- goose_map(code_snippets, "Review this R code: {x}")
}
}
