% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory.R
\name{goose_load}
\alias{goose_load}
\title{Load R Object from Goose Memory}
\usage{
goose_load(name, category = "r_objects", global = TRUE)
}
\arguments{
\item{name}{Character string. Name of the object to load}

\item{category}{Character string. Category where the object was saved (default: "r_objects")}

\item{global}{Logical. If TRUE (default), loads from global memory. If FALSE, loads from project-local memory.}
}
\value{
The R object that was saved
}
\description{
Retrieve a previously saved R object from Goose's memory system.
}
\examples{
\dontrun{
# Load a previously saved model
model <- goose_load("mtcars_model", category = "models")

# Load a dataset
data <- goose_load("iris_data", category = "datasets")
}
}
